/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.pos.TilePos;
import org.joml.Vector2i;

public class WorldFeatureMagmaBoulder
extends WorldFeature {
    final double[][] RADIUS_MAPS = new double[][]{{1.5, 1.5, 1.0}, {1.0, 1.5, 1.0}};

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        TilePos pos = new TilePos(x, y, z);
        while (world.isAirBlock(pos) && pos.y - 1 > 0) {
            pos.down();
        }
        double[] map = this.RADIUS_MAPS[random.nextInt(2)];
        if (this.hasSpace(world, pos.x, pos.y, pos.z)) {
            Vector2i centerXZ = new Vector2i(pos.x, pos.z);
            TilePos queryPos = new TilePos(pos.x, pos.y, pos.z);
            for (int i = 0; i < map.length; ++i) {
                this.generateRadius(world, centerXZ, queryPos, map[i], pos.y + i);
            }
            TilePos circlePos = new TilePos();
            circlePos.x = pos.x() - 2;
            while (circlePos.x < pos.x() + 2) {
                circlePos.z = pos.z() - 2;
                while (circlePos.z < pos.z() + 2) {
                    circlePos.y = pos.y() - 4;
                    while (circlePos.y < pos.y + 4) {
                        if (!world.isAirBlock(circlePos) && random.nextInt(8) == 0) {
                            world.setBlockType(circlePos, Blocks.COBBLE_BASALT);
                        }
                        ++circlePos.y;
                    }
                    ++circlePos.z;
                }
                ++circlePos.x;
            }
        }
        return true;
    }

    private Block<?> getBlockAt(Vector2i center, int x, int z) {
        return Blocks.MAGMA;
    }

    private void plotBlocks(World world, Vector2i center, TilePos queryPos, int x, int y, int z) {
        Block<?> block;
        int xx;
        for (xx = center.x - x; xx <= center.x + x; ++xx) {
            block = this.getBlockAt(center, xx, center.y + z);
            world.setBlockType(queryPos.set(xx, queryPos.y, center.y + z), block);
            world.setBlockType(queryPos.set(xx, queryPos.y, center.y - z), block);
        }
        for (xx = center.x - z; xx <= center.x + z; ++xx) {
            block = this.getBlockAt(center, xx, center.y + x);
            world.setBlockType(queryPos.set(xx, y, center.y + x), block);
            world.setBlockType(queryPos.set(xx, y, center.y - x), block);
        }
    }

    private void generateRadius(World world, Vector2i center, TilePos queryPos, double r, int y) {
        int x = 0;
        int z = (int)r;
        double d = 3.0 - 2.0 * r;
        this.plotBlocks(world, center, queryPos, x, y, z);
        while (z > x) {
            d = d > 0.0 ? d + (double)(4 * (x - --z)) + 10.0 : d + (double)(4 * ++x) + 6.0;
            this.plotBlocks(world, center, queryPos, x, y, z);
        }
    }

    private boolean hasSpace(World world, int xc, int y, int zc) {
        TilePos queryPos = new TilePos();
        queryPos.y = y - 2;
        while (queryPos.y < y + 2) {
            queryPos.x = xc - 2;
            while (queryPos.x < xc + 2) {
                queryPos.z = zc - 2;
                while (queryPos.z < zc + 2) {
                    if (!world.isAirBlock(queryPos) && !world.getBlockType(queryPos).hasTag(BlockTags.NETHER_SURFACE_BLOCK)) {
                        return false;
                    }
                    ++queryPos.z;
                }
                ++queryPos.x;
            }
            ++queryPos.y;
        }
        return true;
    }
}

