/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Arrays;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.input.InputHandler;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.Button;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.controller.ControllerType;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;

public class ScreenControllerSetup
extends Screen {
    private ControllerInput lastController = null;
    private ButtonElement controllerButton;

    public ScreenControllerSetup(Screen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void init() {
        this.controllerButton = new ButtonElement(0, 0, 0, "");
        this.controllerButton.xPosition = this.width / 2 - 100;
        this.controllerButton.yPosition = 16;
        this.controllerButton.width = 200;
        this.controllerButton.height = 20;
        this.buttons.add(this.controllerButton);
        this.buttons.add(new ButtonElement(-1, this.width / 2 - 100, this.height - 40, I18n.getInstance().translateKey("gui.controller_setup.button.back")).setListener(e -> this.mc.displayScreen(this.parentScreen)));
        this.updateDisplay();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mc.controllerInput != this.lastController) {
            this.updateDisplay();
            this.lastController = this.mc.controllerInput;
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.renderBackground();
        super.render(mx, my, partialTick);
        ControllerInput controller = this.mc.controllerInput;
        if (controller != null) {
            boolean swapJoystickAndDPad = controller.getType().getLayout() == ControllerType.Layout.XBOX || controller.getType().getLayout() == ControllerType.Layout.NINTENDO;
            int x = this.width / 2 - 116;
            int y = this.height / 2 - 82;
            int[][] slots = new int[][]{{23, 36}, {64, 67}, {122, 67}, {163, 36}};
            int[][] shoulderSlots = new int[][]{{28, 15}, {179, 15}};
            int[][] triggerSlots = new int[][]{{36, 0}, {179, 0}};
            int[][] metaSlots = new int[][]{{92, 40}, {125, 40}};
            int dPadSlot = swapJoystickAndDPad ? 1 : 0;
            int joyLeftSlot = swapJoystickAndDPad ? 0 : 1;
            int joyRightSlot = 2;
            int faceButtonsSlot = 3;
            GLRenderer.pushFrame();
            GLRenderer.disableState(State.DEPTH_TEST);
            this.drawStringCenteredNoShadow(this.fontRenderer, "(" + controller.getType().getPrintableName() + ")", this.width / 2, 40, 0xFFFFFF);
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/layout.png").bind();
            this.drawTexturedModalRect(x, y, 0, 0, 232, 164);
            this.drawJoystick(controller, x + slots[joyLeftSlot][0], y + slots[joyLeftSlot][1], controller.joyLeft.getX(), controller.joyLeft.getY(), controller.joyLeft.getButton().isPressed());
            this.drawJoystick(controller, x + slots[2][0], y + slots[2][1], controller.joyRight.getX(), controller.joyRight.getY(), controller.joyRight.getButton().isPressed());
            this.drawButton(controller, controller.buttonBack, x + metaSlots[0][0], y + metaSlots[0][1], controller.buttonBack.isPressed());
            this.drawButton(controller, controller.buttonStart, x + metaSlots[1][0], y + metaSlots[1][1], controller.buttonStart.isPressed());
            this.drawButton(controller, controller.buttonLeftTrigger, x + triggerSlots[0][0], y + triggerSlots[0][1], controller.buttonLeftTrigger.isPressed());
            this.drawButton(controller, controller.buttonRightTrigger, x + triggerSlots[1][0], y + triggerSlots[1][1], controller.buttonRightTrigger.isPressed());
            this.drawButton(controller, controller.buttonLeftShoulder, x + shoulderSlots[0][0], y + shoulderSlots[0][1], controller.buttonLeftShoulder.isPressed());
            this.drawButton(controller, controller.buttonRightShoulder, x + shoulderSlots[1][0], y + shoulderSlots[1][1], controller.buttonRightShoulder.isPressed());
            this.drawButtons(controller, x + slots[3][0], y + slots[3][1]);
            this.drawDPad(controller, x + slots[dPadSlot][0], y + slots[dPadSlot][1], controller.digitalPad.up.isPressed(), controller.digitalPad.right.isPressed(), controller.digitalPad.down.isPressed(), controller.digitalPad.left.isPressed());
            GLRenderer.popFrame();
        }
    }

    private void drawButtons(ControllerInput controller, int x, int y) {
        int w = 14;
        this.drawButton(controller, controller.buttonA, x + w, y + w * 2, controller.buttonA.isPressed());
        this.drawButton(controller, controller.buttonB, x + w * 2, y + w, controller.buttonB.isPressed());
        this.drawButton(controller, controller.buttonX, x + 0, y + w, controller.buttonX.isPressed());
        this.drawButton(controller, controller.buttonY, x + w, y + 0, controller.buttonY.isPressed());
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        super.buttonClicked(button);
        if (button.id == 0) {
            int index = this.mc.controllerInput == null ? -1 : Arrays.asList(InputHandler.controllers).indexOf(this.mc.controllerInput);
            do {
                if (++index < InputHandler.controllers.length) continue;
                index = -1;
                break;
            } while (InputHandler.controllers[index] == null);
            if (index == -1) {
                this.mc.controllerInput = null;
                this.mc.setInputType(InputType.KEYBOARD);
            } else {
                this.mc.controllerInput = InputHandler.controllers[index];
                this.mc.setInputType(InputType.CONTROLLER);
            }
            this.updateDisplay();
            this.save();
        }
    }

    @Override
    public void removed() {
        if (this.mc.inputType == InputType.CONTROLLER) {
            this.mc.mouseInput.grabCursor();
        }
    }

    private void updateDisplay() {
        if (this.mc.controllerInput != null) {
            this.controllerButton.displayString = this.mc.controllerInput.getController().getName();
            if (this.controllerButton.displayString.startsWith("SDL GameController ")) {
                this.controllerButton.displayString = this.controllerButton.displayString.substring(19);
            }
        } else {
            this.controllerButton.displayString = I18n.getInstance().translateKey("gui.controller_setup.label.no_controller_selected");
        }
    }

    private void save() {
        GameSettings.SELECTED_CONTROLLER.value = this.mc.controllerInput != null ? this.mc.controllerInput.getGUID() : "";
        GameSettings.saveOptions();
    }

    private void drawButton(ControllerInput controller, Button button, int x, int y, boolean pressed) {
        int u = this.getButtonU(controller, button);
        int v = this.getButtonV(controller, button);
        int sizeU = this.getButtonSizeU(controller, button);
        int sizeV = this.getButtonSizeV(controller, button);
        int vOffset = 0;
        if (pressed) {
            vOffset = sizeV;
        }
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/" + controller.getType().getAssetName() + ".png").bind();
        this.drawTexturedModalRect(x, y, u, v + vOffset, sizeU, sizeV);
    }

    private void drawDPad(ControllerInput controllerInput, int x, int y, boolean up, boolean right, boolean down, boolean left) {
        int u = 0;
        int v = 72;
        int sizeU = 46;
        int sizeV = 46;
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/" + controllerInput.getType().getAssetName() + ".png").bind();
        this.drawTexturedModalRect(x, y, u, v, sizeU, sizeV);
        if (up) {
            this.drawTexturedModalRect(x, y, 46, 72, 46, 15);
        }
        if (right) {
            this.drawTexturedModalRect(x + 31, y, 77, 72, 15, 46);
        }
        if (down) {
            this.drawTexturedModalRect(x, y + 31, 46, 103, 46, 15);
        }
        if (left) {
            this.drawTexturedModalRect(x, y, 46, 72, 15, 46);
        }
    }

    private void drawJoystick(ControllerInput controllerInput, int x, int y, float axisX, float axisY, boolean clicked) {
        int u = 92;
        int v = 72;
        int sizeU = 46;
        int sizeV = 46;
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/controller/" + controllerInput.getType().getAssetName() + ".png").bind();
        this.drawTexturedModalRect(x, y, u, v, sizeU, sizeV);
        int thumbU = clicked ? 184 : 138;
        int thumbV = 72;
        this.drawTexturedModalRect((int)((float)x + axisX * (float)sizeU / 3.0f), (int)((float)y + axisY * (float)sizeV / 3.0f), thumbU, thumbV, sizeU, sizeV);
    }

    private int getButtonU(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.digitalPad.up) {
            return 0;
        }
        if (button == controller.buttonB || button == controller.digitalPad.right) {
            return 18;
        }
        if (button == controller.buttonX || button == controller.digitalPad.down) {
            return 36;
        }
        if (button == controller.buttonY || button == controller.digitalPad.left) {
            return 54;
        }
        if (button == controller.buttonLeftShoulder) {
            return 97;
        }
        if (button == controller.buttonRightShoulder) {
            return 72;
        }
        if (button == controller.buttonLeftTrigger) {
            return 139;
        }
        if (button == controller.buttonRightTrigger) {
            return 122;
        }
        if (button == controller.buttonStart) {
            return 72;
        }
        if (button == controller.buttonBack) {
            return 87;
        }
        return 0;
    }

    private int getButtonV(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.buttonB || button == controller.buttonX || button == controller.buttonY || button == controller.buttonLeftShoulder || button == controller.buttonRightShoulder || button == controller.buttonLeftTrigger || button == controller.buttonRightTrigger) {
            return 0;
        }
        if (button == controller.digitalPad.up || button == controller.digitalPad.right || button == controller.digitalPad.down || button == controller.digitalPad.left) {
            return 36;
        }
        if (button == controller.buttonStart || button == controller.buttonBack) {
            return 26;
        }
        return 0;
    }

    private int getButtonSizeU(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.buttonB || button == controller.buttonX || button == controller.buttonY || button == controller.digitalPad.up || button == controller.digitalPad.right || button == controller.digitalPad.down || button == controller.digitalPad.left) {
            return 18;
        }
        if (button == controller.buttonLeftShoulder || button == controller.buttonRightShoulder) {
            return 25;
        }
        if (button == controller.buttonLeftTrigger || button == controller.buttonRightTrigger) {
            return 17;
        }
        if (button == controller.buttonStart || button == controller.buttonBack) {
            return 15;
        }
        return 0;
    }

    private int getButtonSizeV(ControllerInput controller, Button button) {
        if (button == controller.buttonA || button == controller.buttonB || button == controller.buttonX || button == controller.buttonY || button == controller.digitalPad.up || button == controller.digitalPad.right || button == controller.digitalPad.down || button == controller.digitalPad.left) {
            return 18;
        }
        if (button == controller.buttonLeftShoulder || button == controller.buttonRightShoulder) {
            return 13;
        }
        if (button == controller.buttonLeftTrigger || button == controller.buttonRightTrigger) {
            return 15;
        }
        if (button == controller.buttonStart || button == controller.buttonBack) {
            return 15;
        }
        return 0;
    }
}

