/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeaturePillar
extends WorldFeature {
    private static final int MAX_RADIUS = 8;
    private static final int CIRCLE_SCALE = 6;
    private final int blockId;
    private final boolean doLava;
    private boolean[] buffer = new boolean[WorldFeaturePillar.diameter(8) * WorldFeaturePillar.diameter(8)];

    private static int diameter(int radius) {
        return radius * 2 + 1;
    }

    public WorldFeaturePillar(int blockId, boolean doLava) {
        this.blockId = blockId;
        this.doLava = doLava;
    }

    private float[][] mult(float[][] ma, float[][] mb) {
        float a = ma[0][0];
        float b = ma[0][1];
        float c = ma[0][2];
        float d = ma[1][0];
        float e = ma[1][1];
        float f = ma[1][2];
        float g = ma[2][0];
        float h = ma[2][1];
        float i = ma[2][2];
        float j = mb[0][0];
        float k = mb[0][1];
        float l = mb[0][2];
        float m = mb[1][0];
        float n = mb[1][1];
        float o = mb[1][2];
        float p = mb[2][0];
        float q = mb[2][1];
        float r = mb[2][2];
        return new float[][]{{a * j + b * m + c * p, a * k + b * n + c * q, a * l + b * o + c * r}, {d * j + e * m + f * p, d * k + e * n + f * q, d * l + e * o + f * r}, {g * j + h * m + i * p, g * k + h * n + i * q, g * l + h * o + i * r}};
    }

    private float[] mult(float[][] m, float[] v) {
        return new float[]{m[0][0] * v[0] + m[0][1] * v[1] + m[0][2] * v[2], m[1][0] * v[0] + m[1][1] * v[1] + m[1][2] * v[2], m[2][0] * v[0] + m[2][1] * v[1] + m[2][2] * v[2]};
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int x0 = random.nextInt(16) - 8 + x;
        int z0 = random.nextInt(16) - 8 + z;
        int y0 = y;
        while (this.isEmpty(world, x0, y0, z0)) {
            --y0;
        }
        int x1 = random.nextInt(2) - 2 + x;
        int z1 = random.nextInt(2) - 2 + z;
        int y1 = y;
        while (this.isEmpty(world, x1, y1, z1)) {
            ++y1;
        }
        int length = (y1 += 5) - (y0 -= 5);
        if (length >= 128 || length <= 5) {
            return false;
        }
        int xd = x1 - x0;
        int yd = y1 - y0;
        int zd = z1 - z0;
        float dist = (float)Math.sqrt(xd * xd + yd * yd + zd * zd);
        float xn = (float)xd / dist;
        float zn = (float)zd / dist;
        float[][] sxMatrix = new float[][]{{1.0f, xn, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        float[][] szMatrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, zn, 1.0f}};
        float[][] matrix = this.mult((float[][])sxMatrix, szMatrix);
        float r = random.nextFloat();
        int initRadiusTop = (int)(8.0f - (r * 4.0f + 1.0f));
        r = random.nextFloat();
        int initRadiusBottom = initRadiusTop;
        int initRadiusMin = (int)(r * (float)initRadiusBottom * 0.9f);
        if (this.exposedBase(world, x1, y1 + 1, z1, initRadiusTop) || this.exposedBase(world, x0, y0 - 1, z0, initRadiusBottom)) {
            return false;
        }
        int randomSkip = random.nextInt(8);
        if (randomSkip == 0) {
            initRadiusTop = 0;
            initRadiusMin = 0;
        } else if (randomSkip == 1) {
            initRadiusBottom = 0;
            initRadiusMin = 0;
        }
        float bufferedRadius = initRadiusBottom;
        this.bufferCircle(random, initRadiusBottom);
        for (int dy = 0; dy <= length; ++dy) {
            float radMod;
            float p = (float)dy / (float)length;
            if (randomSkip == 0 && p > 0.5f) break;
            if (randomSkip == 1 && p < 0.5f) continue;
            float lerpedRadius = MathHelper.lerp(initRadiusBottom, initRadiusTop, p);
            float currentRadius = (float)((int)(lerpedRadius * (radMod = (MathHelper.cos(2.0f * p * (float)Math.PI) / 2.0f + 0.5f) * 0.75f + 0.5f) * 6.0f)) / 6.0f;
            if (currentRadius < (float)initRadiusMin) {
                currentRadius = initRadiusMin;
            }
            if (currentRadius != bufferedRadius) {
                this.bufferCircle(random, currentRadius);
                bufferedRadius = currentRadius;
            }
            for (int dx = -8; dx < 8; ++dx) {
                for (int dz = -8; dz < 8; ++dz) {
                    if (!this.getBufferPoint(dx + 8, dz + 8)) continue;
                    float[] v = new float[]{dx, dy, dz};
                    float[] t = this.mult(matrix, v);
                    int xW = x0 + MathHelper.floor(t[0]);
                    int yW = y0 + MathHelper.floor(t[1]);
                    int zW = z0 + MathHelper.floor(t[2]);
                    world.setBlockWithNotify(xW, yW, zW, this.blockId);
                }
            }
        }
        if (this.doLava) {
            int largerRadius = Math.max(initRadiusTop, initRadiusBottom);
            int numFeatures = 8 + random.nextInt(20);
            for (int i = 0; i < numFeatures; ++i) {
                int rx = random.nextInt(WorldFeaturePillar.diameter(largerRadius));
                int rz = random.nextInt(WorldFeaturePillar.diameter(largerRadius));
                int ry = random.nextInt(length);
                if (world.getBlockId(x - largerRadius + rx, y0 + ry, z - largerRadius + rz) != Blocks.COBBLE_NETHERRACK.id()) continue;
                world.setBlockWithNotify(x - largerRadius + rx, y0 + ry, z - largerRadius + rz, Blocks.FLUID_LAVA_FLOWING.id());
                world.scheduledUpdatesAreImmediate = true;
                Blocks.FLUID_LAVA_FLOWING.updateTick(world, x - largerRadius + rx, y0 + ry, z - largerRadius + rz, random, false);
                world.scheduledUpdatesAreImmediate = false;
            }
        }
        return true;
    }

    private boolean exposedBase(World world, int x, int y, int z, int radius) {
        for (int xi = -radius; xi < radius; ++xi) {
            for (int zi = -radius; zi < radius; ++zi) {
                if (Blocks.solid[world.getBlockId(x + xi, y, z + zi)]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEmpty(World world, int x, int y, int z) {
        if (y < 0 || y >= world.getHeightBlocks()) {
            return false;
        }
        return !Blocks.solid[world.getBlockId(x, y, z)];
    }

    private void bufferCircle(Random rand, float r) {
        Arrays.fill(this.buffer, false);
        if ((double)r <= 0.5) {
            return;
        }
        int ir = (int)(r * 6.0f);
        int x1 = 9;
        int y1 = 9;
        int x = 0;
        int y = ir;
        int p = 1 - ir;
        this.plotPoints(9, 9, x / 6, y / 6);
        while (x < y) {
            p = p < 0 ? (p += 2 * x + 1) : (p += 2 * (++x - --y) + 1);
            this.plotPoints(9, 9, x / 6, y / 6);
        }
    }

    private void drawLine(int x0, int x1, int y, boolean value) {
        for (int x = x0; x <= x1; ++x) {
            this.setBufferPoint(x, y, value);
        }
    }

    private void plotPoints(int cx, int cy, int x, int y) {
        this.drawLine(cx - x, cx + x, cy - y, true);
        this.drawLine(cx - x, cx + x, cy + y, true);
        this.drawLine(cx - y, cx + y, cy - x, true);
        this.drawLine(cx - y, cx + y, cy + x, true);
    }

    private void setBufferPoint(int x, int y, boolean value) {
        this.buffer[x * WorldFeaturePillar.diameter((int)8) + y] = value;
    }

    private boolean getBufferPoint(int x, int y) {
        return this.buffer[x * WorldFeaturePillar.diameter(8) + y];
    }
}

