/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericRepeater<T extends BlockLogicRepeater>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel[] models = new StaticBlockModel[4];
    @NotNull
    public final StaticBlockModel[] modelsActive = new StaticBlockModel[4];

    public BlockModelGenericRepeater(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/repeater/0"));
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = BlockModelDispatcher.loadDataModel("minecraft:block/repeater/" + i).asModel();
            this.modelsActive[i] = BlockModelDispatcher.loadDataModel("minecraft:block/repeater/active" + i).asModel();
        }
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int meta = worldSource.getBlockData(tilePos);
        int direction = meta & 3;
        int tick = (meta & 0xC) >> 2;
        return (((BlockLogicRepeater)this.block.getLogic()).isRepeaterPowered ? this.modelsActive[tick & 3] : this.models[tick & 3]).renderAttached(this, tessellator, worldSource, tilePos, 0, 4 - direction, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }
}

