/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.MobAge;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.season.Seasons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;

public class MobDeer
extends MobAnimal
implements AgedMob {
    @NotNull
    private final MobAge age;
    @NotNull
    public BrainState brainState = new RoamingBrainState(this);
    public List<WeightedRandomLootObject> burningMobDrops = new ArrayList<WeightedRandomLootObject>();
    private static final float SPOOK_DISTANCE = 10.0f;
    private static final float FLEE_DISTANCE = 7.0f;
    private static final float SNEAK_FLEE_DISTANCE = 3.0f;

    public MobDeer(World world) {
        super(world);
        this.setTextureIdentifier("minecraft", "deer");
        this.setSize(0.9f, 1.3f);
        this.moveSpeed = 0.8f;
        this.mobDrops.add(new WeightedRandomLootObject(Items.FOOD_VENISON_RAW.getDefaultStack(), 1, 2));
        this.burningMobDrops.add(new WeightedRandomLootObject(Items.FOOD_VENISON_COOKED.getDefaultStack(), 1, 2));
        this.age = MobAge.newRandom(this, 280, 14, 224);
        this.jumpHeight = 0.5;
        this.brainState.init();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.getMobAge().tick(this.world);
    }

    @Override
    public boolean hurt(@Nullable Entity attacker, int damage, DamageType type) {
        if (attacker != null) {
            this.brainState = new FleeingBrainState(this, attacker);
            this.brainState.init();
        }
        return super.hurt(attacker, damage, type);
    }

    @Override
    protected void updateAI() {
        super.updateAI();
        @Nullable BrainState newBrainState = this.brainState.tick();
        if (newBrainState != null && newBrainState != this.brainState) {
            this.brainState = newBrainState;
            this.brainState.init();
        }
    }

    @Override
    protected List<WeightedRandomLootObject> getMobDrops() {
        if (this.remainingFireTicks > 0) {
            return this.burningMobDrops;
        }
        return this.mobDrops;
    }

    @Nullable
    protected Entity findThreatNearby() {
        int dist = 10;
        Player player = this.world.getClosestPlayer(this.x, this.y, this.z, 10.0);
        if (player != null && player.getGamemode().hasHostileMobs()) {
            return player;
        }
        if (player == null) {
            AABBd checkBB = new AABBd(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
            MathHelper.aabbGrow(checkBB, 8.0, 4.0, 8.0, checkBB);
            List<MobWolf> nearbyWolves = this.world.getEntitiesWithinAABB(MobWolf.class, checkBB);
            if (!nearbyWolves.isEmpty()) {
                @NotNull MobWolf closestWolf = nearbyWolves.get(0);
                double closestWolfDist = this.distanceToSqr(closestWolf);
                for (int i = 1; i < nearbyWolves.size(); ++i) {
                    @NotNull MobWolf iWolf = nearbyWolves.get(i);
                    double iWolfDist = this.distanceToSqr(iWolf);
                    if (!(iWolfDist < closestWolfDist)) continue;
                    closestWolf = iWolf;
                    closestWolfDist = iWolfDist;
                }
                return closestWolf;
            }
        }
        return null;
    }

    private void findRandomPathToRunTo(@NotNull Entity threat) {
        this.getPathAwayFromPoint(this.x + (double)this.random.nextInt(8) - 4.0, this.z + (double)this.random.nextInt(8) - 4.0, threat.x, threat.z);
    }

    protected void getPathAwayFromPoint(double x, double z, double pX, double pZ) {
        int scale = 10;
        @NotNull Vector3d vec = new Vector3d(x - pX, 0.0, z - pZ).normalize().mul(10.0);
        Vector3d safePoint = vec.add(this.x, this.y, this.z);
        this.pathToEntity = this.world.getEntityPathToTilePos(this, new TilePos(safePoint), 16.0f);
    }

    @Override
    @NotNull
    public MobAge getMobAge() {
        return this.age;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.age.writeTag(tag);
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            return 4;
        }
        return 0;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.age.readTag(tag);
    }

    @Override
    public String getLivingSound() {
        return "mob.cow";
    }

    @Override
    protected String getHurtSound() {
        return "mob.cowhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.cowhurt";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    static /* synthetic */ Random access$300(MobDeer x0) {
        return x0.random;
    }

    static /* synthetic */ Random access$400(MobDeer x0) {
        return x0.random;
    }

    static /* synthetic */ Random access$500(MobDeer x0) {
        return x0.random;
    }

    static /* synthetic */ Random access$600(MobDeer x0) {
        return x0.random;
    }

    public static class RoamingBrainState
    extends BrainState {
        public RoamingBrainState(@NotNull MobDeer deer) {
            super(deer);
        }

        @Override
        public void init() {
            this.deer.doRandomWalk = true;
            this.deer.moveSpeed = 0.4f;
        }

        @Override
        @Nullable
        public BrainState tick() {
            @Nullable Entity closestThreat = this.deer.findThreatNearby();
            if (closestThreat != null) {
                double distSqr = this.deer.distanceToSqr(closestThreat);
                if (!closestThreat.isSneaking() && distSqr < 49.0 || distSqr < 9.0) {
                    return new FleeingBrainState(this.deer, closestThreat);
                }
                if (distSqr < 100.0) {
                    return new SpookedBrainState(this.deer, closestThreat);
                }
            }
            if (this.deer.random.nextInt(200) == 0) {
                return new SniffingBrainState(this.deer);
            }
            return null;
        }
    }

    public static abstract class BrainState {
        @NotNull
        protected final MobDeer deer;

        public BrainState(@NotNull MobDeer deer) {
            this.deer = deer;
        }

        public abstract void init();

        @Nullable
        public abstract BrainState tick();
    }

    public static class FleeingBrainState
    extends BrainState {
        private static final int MAX_FLEE_TIME = 200;
        private static final int NEW_PATH_TIME = 30;
        public int fleeTimer = 200;
        public int newPathTimer = 30;
        @NotNull
        public Entity threat;

        public FleeingBrainState(@NotNull MobDeer deer, @NotNull Entity threat) {
            super(deer);
            this.threat = threat;
        }

        @Override
        public void init() {
            this.deer.doRandomWalk = false;
            this.deer.moveSpeed = 2.5f;
            this.syncToOtherDeer();
        }

        private void syncToOtherDeer() {
            AABBd checkBB = new AABBd(this.deer.x, this.deer.y, this.deer.z, this.deer.x + 1.0, this.deer.y + 1.0, this.deer.z + 1.0);
            MathHelper.aabbGrow(checkBB, 8.0, 4.0, 8.0, checkBB);
            @NotNull List<@NotNull MobDeer> nearbyDeer = this.deer.world.getEntitiesWithinAABB(MobDeer.class, checkBB);
            for (MobDeer deer : nearbyDeer) {
                if (deer.brainState instanceof FleeingBrainState) continue;
                deer.brainState = new TransitionalBrainState(deer, new FleeingBrainState(deer, this.threat), this.deer.random.nextInt(5));
            }
        }

        @Override
        @Nullable
        public BrainState tick() {
            double distSqr;
            double threatDistSqr = this.deer.distanceToSqr(this.threat);
            @Nullable Entity closestThreat = this.deer.findThreatNearby();
            if (closestThreat != null && closestThreat != this.threat && (distSqr = this.deer.distanceToSqr(closestThreat)) < threatDistSqr) {
                this.threat = closestThreat;
                threatDistSqr = distSqr;
            }
            if (threatDistSqr > 100.0) {
                --this.fleeTimer;
                if (this.fleeTimer <= 0) {
                    return new RoamingBrainState(this.deer);
                }
            } else {
                this.fleeTimer = 200;
            }
            if (this.newPathTimer <= 0) {
                this.newPathTimer = 30;
                this.deer.findRandomPathToRunTo(this.threat);
            } else {
                --this.newPathTimer;
            }
            if (this.deer.onGround && !this.deer.isJumping && this.deer.isWalking) {
                this.deer.yd = 0.35;
                float f = this.deer.yRot * 0.01745329f;
                this.deer.xd -= (double)(MathHelper.sin(f) * 0.25f);
                this.deer.zd += (double)(MathHelper.cos(f) * 0.25f);
            }
            return null;
        }
    }

    public static class SpookedBrainState
    extends BrainState {
        @NotNull
        public Entity threat;
        public double threatInitialDistSqr;

        public SpookedBrainState(@NotNull MobDeer deer, @NotNull Entity threat) {
            super(deer);
            this.threat = threat;
            this.threatInitialDistSqr = this.deer.distanceToSqr(this.threat);
        }

        @Override
        public void init() {
            this.deer.pathToEntity = null;
            this.deer.doRandomWalk = false;
            this.syncToOtherDeer();
        }

        private void syncToOtherDeer() {
            AABBd checkBB = new AABBd(this.deer.x, this.deer.y, this.deer.z, this.deer.x + 1.0, this.deer.y + 1.0, this.deer.z + 1.0);
            MathHelper.aabbGrow(checkBB, 8.0, 4.0, 8.0, checkBB);
            @NotNull List<@NotNull MobDeer> nearbyDeer = this.deer.world.getEntitiesWithinAABB(MobDeer.class, checkBB);
            for (MobDeer deer : nearbyDeer) {
                if (deer.brainState instanceof SpookedBrainState) continue;
                deer.brainState = new TransitionalBrainState(deer, new SpookedBrainState(deer, this.threat), this.deer.random.nextInt(10));
            }
        }

        @Override
        @Nullable
        public BrainState tick() {
            @Nullable Entity closestThreat = this.deer.findThreatNearby();
            if (closestThreat != null && closestThreat != this.threat) {
                double distSqr = this.deer.distanceToSqr(closestThreat);
                if (!closestThreat.isSneaking() && distSqr < 49.0 || distSqr < 9.0) {
                    return new FleeingBrainState(this.deer, closestThreat);
                }
                if (distSqr < 100.0) {
                    return new SpookedBrainState(this.deer, closestThreat);
                }
            }
            double threatCurrentDistSqr = this.deer.distanceToSqr(this.threat);
            if (!this.threat.isSneaking() && threatCurrentDistSqr < this.threatInitialDistSqr - 2.0 || !this.threat.isSneaking() && threatCurrentDistSqr < 49.0 || threatCurrentDistSqr < 9.0) {
                return new FleeingBrainState(this.deer, this.threat);
            }
            if (threatCurrentDistSqr > this.threatInitialDistSqr + 4.0) {
                return new RoamingBrainState(this.deer);
            }
            this.deer.lookAt(this.threat, 30.0f, 30.0f);
            return null;
        }
    }

    public static class SniffingBrainState
    extends BrainState {
        public static final int MIN_INTO_SNIFF_TIME = 5;
        public static final int MAX_INTO_SNIFF_TIME = 15;
        public static final int MIN_SNIFF_TIME = 40;
        public static final int MAX_SNIFF_TIME = 80;
        public static final int MIN_OUT_OF_SNIFF_TIME = 5;
        public static final int MAX_OUT_OF_SNIFF_TIME = 10;
        public final int intoSniffTime = 5 + MobDeer.access$300(this.deer).nextInt(10);
        public final int sniffTime = 40 + MobDeer.access$400(this.deer).nextInt(40);
        public final int outOfSniffTime = 5 + MobDeer.access$500(this.deer).nextInt(5);
        public final float leanPercentage = MobDeer.access$600(this.deer).nextFloat();
        public int timer = 0;
        @Nullable
        public BrainState nextBrainState = null;

        public SniffingBrainState(@NotNull MobDeer deer) {
            super(deer);
        }

        @Override
        public void init() {
            this.deer.doRandomWalk = true;
            this.deer.moveSpeed = 0.25f;
        }

        @Override
        @Nullable
        public BrainState tick() {
            @Nullable Entity closestThreat = this.deer.findThreatNearby();
            if (closestThreat != null) {
                double distSqr = this.deer.distanceToSqr(closestThreat);
                BrainState nextBrainState = !closestThreat.isSneaking() && distSqr < 49.0 || distSqr < 9.0 ? new FleeingBrainState(this.deer, closestThreat) : (distSqr < 100.0 ? new SpookedBrainState(this.deer, closestThreat) : null);
                if (nextBrainState != null) {
                    if (this.timer < this.intoSniffTime + this.sniffTime) {
                        this.timer = this.intoSniffTime + this.sniffTime;
                    }
                    this.nextBrainState = nextBrainState;
                }
            }
            if (this.timer >= this.intoSniffTime + this.sniffTime + this.outOfSniffTime) {
                if (this.nextBrainState != null) {
                    return this.nextBrainState;
                }
                return new RoamingBrainState(this.deer);
            }
            ++this.timer;
            return null;
        }
    }

    public static class TransitionalBrainState
    extends BrainState {
        @NotNull
        private final BrainState oldBrainState;
        @NotNull
        private final BrainState newBrainState;
        private long ticksToSwitch;

        public TransitionalBrainState(@NotNull MobDeer deer, @NotNull BrainState newBrainState, long ticksToSwitch) {
            super(deer);
            this.oldBrainState = deer.brainState;
            this.newBrainState = newBrainState;
            this.ticksToSwitch = ticksToSwitch;
        }

        @Override
        public void init() {
        }

        @Override
        @Nullable
        public BrainState tick() {
            if (this.ticksToSwitch > 0L) {
                --this.ticksToSwitch;
                return this.oldBrainState.tick();
            }
            return this.newBrainState;
        }
    }
}

