/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelCrossedSquares;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockModelCrossedSquaresRotatable<T extends BlockLogic>
extends BlockModelCrossedSquares<T> {
    public BlockModelCrossedSquaresRotatable(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        float brightness = 1.0f;
        tessellator.setLightmapCoord1i(this.block.getLightIndex(worldSource, tilePos));
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, tilePos, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque3f(brightness * r, brightness * g, brightness * b);
        int metadata = worldSource.getBlockData(tilePos);
        Direction dir = BlockLogicRotatable.getDirectionFromMeta(metadata);
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata);
        if (BlockModelCrossedSquaresRotatable.renderBlocks.overrideBlockTexture != null) {
            texIndex = BlockModelCrossedSquaresRotatable.renderBlocks.overrideBlockTexture;
        }
        double minX = -0.45;
        double maxX = 0.45;
        double minY = -0.5;
        double maxY = 0.5;
        double minZ = -0.45;
        double maxZ = 0.45;
        double minU = texIndex.getIconUMin();
        double maxU = texIndex.getIconUMax();
        double minV = texIndex.getIconVMin();
        double maxV = texIndex.getIconVMax();
        boolean flipUVs = dir == Direction.WEST || dir == Direction.SOUTH || dir == Direction.DOWN;
        Vec3[] vertices = new Vec3[]{Vec3.getTempVec3(-0.45, 0.5, -0.45), Vec3.getTempVec3(-0.45, -0.5, -0.45), Vec3.getTempVec3(0.45, -0.5, 0.45), Vec3.getTempVec3(0.45, 0.5, 0.45), Vec3.getTempVec3(-0.45, 0.5, 0.45), Vec3.getTempVec3(-0.45, -0.5, 0.45), Vec3.getTempVec3(0.45, -0.5, -0.45), Vec3.getTempVec3(0.45, 0.5, -0.45)};
        for (int vi = 0; vi < 8; ++vi) {
            switch (dir) {
                case NORTH: {
                    vertices[vi].rotateAroundX(-1.5707964f);
                    break;
                }
                case SOUTH: {
                    vertices[vi].rotateAroundX(1.5707964f);
                    break;
                }
                case EAST: {
                    vertices[vi].rotateAroundZ(-1.5707964f);
                    break;
                }
                case WEST: {
                    vertices[vi].rotateAroundZ(1.5707964f);
                    break;
                }
                case DOWN: {
                    vertices[vi].rotateAroundX((float)Math.PI);
                }
            }
            vertices[vi].rotateAroundY((float)Math.PI);
            vertices[vi].x += (double)tilePos.x() + 0.5;
            vertices[vi].y += (double)tilePos.y() + 0.5;
            vertices[vi].z += (double)tilePos.z() + 0.5;
        }
        for (int side = 0; side < 4; ++side) {
            Vec3 v4;
            Vec3 v3;
            Vec3 v2;
            Vec3 v1;
            if (side == 0) {
                v1 = vertices[0];
                v2 = vertices[1];
                v3 = vertices[2];
                v4 = vertices[3];
            } else if (side == 1) {
                v1 = vertices[3];
                v2 = vertices[2];
                v3 = vertices[1];
                v4 = vertices[0];
            } else if (side == 2) {
                v1 = vertices[4];
                v2 = vertices[5];
                v3 = vertices[6];
                v4 = vertices[7];
            } else {
                v1 = vertices[7];
                v2 = vertices[6];
                v3 = vertices[5];
                v4 = vertices[4];
            }
            tessellator.addVertexWithUV(v1.x, v1.y, v1.z, minU, minV);
            tessellator.addVertexWithUV(v2.x, v2.y, v2.z, minU, maxV);
            tessellator.addVertexWithUV(v3.x, v3.y, v3.z, maxU, maxV);
            tessellator.addVertexWithUV(v4.x, v4.y, v4.z, maxU, minV);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

