/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleVentSmoke
extends Particle {
    private final float oSize;

    public ParticleVentSmoke(World world, double x, double y, double z, double xa, double ya, double za, float scale, int data) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += xa;
        this.yd += ya;
        this.zd += za;
        if (data == 1) {
            this.gCol = this.bCol = (float)(1.0 - Math.random() * 0.2);
            this.rCol = this.bCol;
        } else {
            this.gCol = this.bCol = (float)(Math.random() * 0.3);
            this.rCol = this.bCol;
        }
        this.size *= 1.0f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = (int)(20.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime *= (int)scale;
        this.noPhysics = false;
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        float size = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (size < 0.0f) {
            size = 0.0f;
        }
        if (size > 1.0f) {
            size = 1.0f;
        }
        this.size = this.oSize * size;
        super.render(t, partialTick);
    }

    @Override
    public void tick() {
        int val;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if ((val = 14 - this.age * 14 / this.lifetime) > 7) {
            val = 7;
        }
        this.tex = val >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.yd += 0.004;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

