/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicRubyglass
extends BlockLogic {
    public BlockLogicRubyglass(Block<?> block) {
        super(block, Materials.STONE);
        block.setTicking(true);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return new ItemStack[]{new ItemStack(Items.RUBYGLASS_CRYSTAL_CRACKED, world.rand.nextInt(3))};
    }

    @Override
    public float getAmbientOcclusionStrength(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return 0.0f;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        int dir;
        Direction direction;
        TilePos checkPos;
        Block<?> checkBlock;
        if (world.isClientSide) {
            return;
        }
        if (world.dimension != Dimension.NETHER) {
            return;
        }
        if (rand.nextInt(10) == 0 && (checkBlock = world.getBlockType(checkPos = tilePos.add(direction = Direction.getDirectionById(dir = rand.nextInt(6)), new TilePos()))) == Blocks.AIR) {
            float yaw;
            float pitch;
            switch (dir) {
                case 0: {
                    pitch = 0.0f;
                    yaw = 0.0f;
                    break;
                }
                case 1: {
                    pitch = (float)Math.PI;
                    yaw = 0.0f;
                    break;
                }
                case 2: {
                    pitch = 1.5707964f;
                    yaw = 0.0f;
                    break;
                }
                case 3: {
                    pitch = -1.5707964f;
                    yaw = 0.0f;
                    break;
                }
                case 4: {
                    pitch = 1.5707964f;
                    yaw = 1.5707964f;
                    break;
                }
                case 5: {
                    pitch = 1.5707964f;
                    yaw = -1.5707964f;
                    break;
                }
                default: {
                    return;
                }
            }
            @NotNull EntityLightning lightning = new EntityLightning(world, checkPos.x, checkPos.y, checkPos.z);
            lightning.r = 1.0f;
            lightning.g = 0.3f;
            lightning.b = 0.1f;
            lightning.pitch = pitch;
            lightning.yaw = yaw;
            lightning.silent = true;
            lightning.scale = 0.125f;
            lightning.flipped = true;
            world.addWeatherEffect(lightning);
        }
    }
}

