/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPainting
extends Item {
    public ItemPainting(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        if (!world.isClientSide && !player.isSneaking()) {
            player.displayPaintingPickerScreen();
        }
        return selfStack;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (side.isVertical() || player == null) {
            return false;
        }
        int direction = switch (side) {
            case Side.NORTH -> 0;
            case Side.SOUTH -> 2;
            case Side.WEST -> 1;
            case Side.EAST -> 3;
            default -> 0;
        };
        EntityPainting entity = new EntityPainting(world, blockPos.x(), blockPos.y(), blockPos.z(), direction, player.getSelectedArt().key);
        if (entity.canStay()) {
            if (!world.isClientSide) {
                world.entityJoinedWorld(entity);
            }
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        return false;
    }
}

