/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeTags;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.generate.chunk.perlin.SurfaceGenerator;
import net.minecraft.core.world.noise.FractalNoise3D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise3D;
import org.jetbrains.annotations.NotNull;

public class SurfaceGeneratorNether
implements SurfaceGenerator {
    @NotNull
    private final World world;
    @NotNull
    private final FractalNoise3D<ImprovedPerlinNoise> beachNoise;
    @NotNull
    private final FractalNoise3D<ImprovedPerlinNoise> soilNoise;

    public SurfaceGeneratorNether(@NotNull World world) {
        this.world = world;
        this.beachNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 4, 40));
        this.soilNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 4, 44));
    }

    @Override
    public void generateSurface(@NotNull Chunk chunk, @NotNull ChunkGeneratorResult result) {
        int oceanY = this.world.getWorldType().getOceanY();
        int minY = this.world.getWorldType().getMinY(this.world);
        int maxY = this.world.getWorldType().getMaxY(this.world);
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        int oceanBlock = this.world.getWorldType().getOceanBlockId();
        int worldFillBlock = this.world.getWorldType().getFillerBlockId();
        Random rand = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        double beachScale = 0.03125;
        double[] sandBeachNoise = this.beachNoise.getRegion(null, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, beachScale, beachScale, 1.0);
        double[] gravelBeachNoise = this.beachNoise.getRegion(null, chunkX * 16, 109.0134, chunkZ * 16, 16, 1, 16, beachScale, 1.0, beachScale);
        double[] soilThicknessNoise = this.soilNoise.getRegion(null, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, beachScale * 2.0, beachScale * 2.0, beachScale * 2.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                boolean generateSoulSandBeach = sandBeachNoise[z + x * 16] + rand.nextDouble() * 0.2 > 0.0;
                boolean generateGravelBeach = gravelBeachNoise[z + x * 16] + rand.nextDouble() * 0.2 > 0.0;
                int soilThickness = (int)(soilThicknessNoise[z + x * 16] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int currentLayerDepth = -1;
                int topBlock = -1;
                int fillerBlock = -1;
                Biome lastBiome = null;
                for (int y = maxY; y >= minY; --y) {
                    Biome biome = chunk.getBlockBiome(x, y, z);
                    if (biome == null) {
                        biome = this.world.getBiomeProvider().getBiome(chunkX * 16 + x, y >> 3, chunkZ * 16 + z);
                    }
                    int block = result.getBlock(x, y, z);
                    if ((biome != lastBiome || topBlock == -1 || fillerBlock == -1) && block == 0) {
                        topBlock = (short)biome.getSurfaceProperties().getTopBlock().id();
                        fillerBlock = (short)biome.getSurfaceProperties().getFillerBlock().id();
                    }
                    lastBiome = biome;
                    if (block == 0) {
                        currentLayerDepth = -1;
                        continue;
                    }
                    if (block != worldFillBlock) continue;
                    if (currentLayerDepth == -1) {
                        if (soilThickness <= 0) {
                            topBlock = 0;
                            fillerBlock = (short)Blocks.NETHERRACK.id();
                        } else {
                            boolean biomeGeneratesSulfur = biome.hasTag(BiomeTags.HAS_SULFUR_POOLS);
                            if (y >= minY + oceanY - 4 && y <= minY + oceanY + 1) {
                                topBlock = (short)biome.getSurfaceProperties().getTopBlock().id();
                                fillerBlock = (short)biome.getSurfaceProperties().getFillerBlock().id();
                                if (generateGravelBeach) {
                                    topBlock = (short)Blocks.GRAVEL.id();
                                    fillerBlock = (short)Blocks.GRAVEL.id();
                                }
                                if (generateSoulSandBeach) {
                                    topBlock = (short)Blocks.SOULSAND.id();
                                    fillerBlock = (short)Blocks.SOULSAND.id();
                                }
                            } else if (y <= oceanY && biomeGeneratesSulfur) {
                                topBlock = (short)Blocks.BRIMSAND.id();
                                fillerBlock = (short)Blocks.BRIMSAND.id();
                            }
                        }
                        if (y < minY + oceanY && topBlock == 0) {
                            topBlock = (short)oceanBlock;
                        }
                        currentLayerDepth = soilThickness + 2;
                        if (y >= minY + oceanY - 1) {
                            result.setBlock(x, y, z, topBlock);
                            continue;
                        }
                        result.setBlock(x, y, z, fillerBlock);
                        continue;
                    }
                    if (currentLayerDepth > 0) {
                        --currentLayerDepth;
                        result.setBlock(x, y, z, fillerBlock);
                    }
                    if (currentLayerDepth != 0 || !biome.hasTag(BiomeTags.HAS_SULFUR_POOLS) || fillerBlock != Blocks.BRIMSAND.id()) continue;
                    currentLayerDepth = rand.nextInt(4) + 2;
                    fillerBlock = (short)Blocks.BRIMSAND.id();
                }
            }
        }
    }
}

