/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.util.helper.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonElement
extends Gui
implements GuiElement {
    public static final int STATE_DISABLED = 0;
    public static final int STATE_DEFAULT = 1;
    public static final int STATE_HOVERED = 2;
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public IconCoordinate defaultTexture;
    public IconCoordinate hoveredTexture;
    public IconCoordinate disabledTexture;
    public int id;
    public boolean enabled = true;
    public boolean visible = true;
    public boolean playSound = true;
    public Listener<ButtonElement> listener;

    public ButtonElement(int id, int xPosition, int yPosition, String text) {
        this(id, xPosition, yPosition, 200, 20, text);
    }

    public ButtonElement(int id, int xPosition, int yPosition, int width, int height, String text) {
        this.id = id;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.displayString = text;
        this.setDefaultTextures();
    }

    protected void setDefaultTextures() {
        this.defaultTexture = TextureRegistry.getTexture("minecraft:gui/widgets/button/button");
        this.hoveredTexture = TextureRegistry.getTexture("minecraft:gui/widgets/button/button_highlighted");
        this.disabledTexture = TextureRegistry.getTexture("minecraft:gui/widgets/button/button_disabled");
    }

    @NotNull
    public ButtonElement setTextures(@Nullable String defaultTexture, @Nullable String hoveredTexture, @Nullable String disabledTexture) {
        if (defaultTexture != null) {
            this.defaultTexture = TextureRegistry.getTexture(defaultTexture);
        }
        if (hoveredTexture != null) {
            this.hoveredTexture = TextureRegistry.getTexture(hoveredTexture);
        }
        if (disabledTexture != null) {
            this.disabledTexture = TextureRegistry.getTexture(disabledTexture);
        }
        return this;
    }

    protected int getButtonState(boolean hovered) {
        int state = 1;
        if (!this.enabled) {
            state = 0;
        } else if (hovered) {
            state = 2;
        }
        return state;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        if (mouseOver && this.visible && this.enabled) {
            mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        IconCoordinate tex = switch (state) {
            case 0 -> this.disabledTexture;
            case 2 -> this.hoveredTexture;
            default -> this.defaultTexture;
        };
        this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, tex);
        this.mouseDragged(mc, mouseX, mouseY);
        int textColor = switch (state) {
            case 0 -> 0xA0A0A0;
            case 1 -> 0xE0E0E0;
            default -> 0xFFFFA0;
        };
        this.drawStringCenteredShadow(mc.font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    public void mouseReleased(int mouseX, int mouseY) {
    }

    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        return this.enabled && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    @NotNull
    public ButtonElement setListener(@Nullable Listener<ButtonElement> listener) {
        this.listener = listener;
        return this;
    }

    @NotNull
    public ButtonElement mute() {
        this.playSound = false;
        return this;
    }

    @NotNull
    public ButtonElement hide() {
        this.visible = false;
        return this;
    }

    @Override
    public void setX(int x) {
        this.xPosition = x;
    }

    @Override
    public void setY(int y) {
        this.yPosition = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getX() {
        return this.xPosition;
    }

    @Override
    public int getY() {
        return this.yPosition;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

