/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class EntityCameraThirdPersonRear
extends EntityCamera {
    protected float lastpartialTick = 0.0f;
    protected double lastCameraDistance = 0.0;

    public EntityCameraThirdPersonRear(@NotNull Minecraft mc, @NotNull Mob entity) {
        super(mc, entity);
    }

    @Override
    public boolean showPlayer() {
        return true;
    }

    private double getCameraDistance(float partialTick) {
        if (partialTick == this.lastpartialTick) {
            return this.lastCameraDistance;
        }
        int numSteps = 5;
        double offset = 0.5;
        float yRot = (float)this.getYRot();
        float xRot = (float)this.getXRot();
        double x = super.getX(partialTick);
        double y = super.getY(partialTick);
        double z = super.getZ(partialTick);
        double dx = -MathHelper.sin(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI);
        double dz = MathHelper.cos(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI);
        double dy = -MathHelper.sin(xRot / 180.0f * (float)Math.PI);
        Vector3d start = new Vector3d(x, y, z);
        double cameraDistance = start.distance(x - (double)numSteps * dx, y - (double)numSteps * dy, z - (double)numSteps * dz) - offset;
        for (int i = 0; i <= numSteps; ++i) {
            HitResult hitResult = this.mc.currentWorld.checkBlockCollisionBetweenPoints(start, new Vector3d(x - (double)i * dx, y - (double)i * dy, z - (double)i * dz), false, true, false);
            if (hitResult == null) continue;
            double distance = hitResult.location.distance(x, y, z) - offset;
            if (distance < 0.0) {
                distance = 0.0;
            }
            cameraDistance = distance;
            break;
        }
        this.lastpartialTick = partialTick;
        this.lastCameraDistance = cameraDistance;
        return cameraDistance;
    }

    @Override
    public double getX(float partialTick) {
        float yRot = (float)this.getYRot(partialTick);
        float xRot = (float)this.getXRot(partialTick);
        double cameraDistance = this.getCameraDistance(partialTick);
        double dx = (double)(-MathHelper.sin(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI)) * cameraDistance;
        return super.getX(partialTick) - dx;
    }

    @Override
    public double getY(float partialTick) {
        float xRot = (float)this.getXRot(partialTick);
        double cameraDistance = this.getCameraDistance(partialTick);
        double dy = (double)(-MathHelper.sin(xRot / 180.0f * (float)Math.PI)) * cameraDistance;
        return super.getY(partialTick) - dy;
    }

    @Override
    public double getZ(float partialTick) {
        float yRot = (float)this.getYRot(partialTick);
        float xRot = (float)this.getXRot(partialTick);
        double cameraDistance = this.getCameraDistance(partialTick);
        double dz = (double)(MathHelper.cos(yRot / 180.0f * (float)Math.PI) * MathHelper.cos(xRot / 180.0f * (float)Math.PI)) * cameraDistance;
        return super.getZ(partialTick) - dz;
    }

    @Override
    public double getYRot(float partialTick) {
        return super.getYRot(partialTick);
    }

    @Override
    public double getXRot(float partialTick) {
        return super.getXRot(partialTick);
    }
}

