/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL41;

public class FogManager {
    public static final int FOG_MODE_SKY = -1;
    public static final int FOG_MODE_NORMAL = 0;
    @NotNull
    public final Minecraft mc;
    public float fogRed;
    public float fogGreen;
    public float fogBlue;
    public float fogBrightnessOld;
    public float fogBrightness;

    public FogManager(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    public void updateBrightness() {
        this.fogBrightnessOld = this.fogBrightness;
        float fogModifier = this.mc.currentWorld.getCurrentWeather() != null ? this.mc.currentWorld.getCurrentWeather().getFogDistanceMultiplier() : 1.0f;
        fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.currentWorld.getWeatherManager().getWeatherIntensity() * this.mc.currentWorld.getWeatherManager().getWeatherPower();
        float brightnessAtCamera = this.mc.currentWorld.getLightBrightness(this.mc.activeCamera.getTilePos());
        if (this.mc.fullbright) {
            brightnessAtCamera = 1.0f;
        }
        float renderDistanceModifier = (float)(GameSettings.RENDER_DISTANCE.highest - (Integer)GameSettings.RENDER_DISTANCE.value) * fogModifier / (float)GameSettings.RENDER_DISTANCE.highest;
        float newBrightness = brightnessAtCamera * (1.0f - renderDistanceModifier) + renderDistanceModifier;
        this.fogBrightness += (newBrightness - this.fogBrightness) * 0.1f;
    }

    @NotNull
    public FogState setupFog(int fogMode, float farPlaneDistance, float partialTick, @NotNull FogState dest) {
        dest.fogColor.set(this.fogRed, this.fogGreen, this.fogBlue);
        int cameraState = CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTick) ? 1 : (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.LAVA, partialTick) ? 2 : 0);
        if (!((Boolean)GameSettings.FOG.value).booleanValue() && fogMode != -1 && cameraState == 0) {
            return dest.disable();
        }
        switch (cameraState) {
            case 1: {
                dest.fogMode = FogState.Mode.EXP;
                dest.fogDensity = 0.1f;
                break;
            }
            case 2: {
                dest.fogMode = FogState.Mode.EXP;
                dest.fogDensity = 2.0f;
                break;
            }
            default: {
                Screen screen;
                float fogDistance = farPlaneDistance;
                float maxFogDistance = GameSettings.RENDER_DISTANCE.highest * 16;
                float fogModifier = this.mc.currentWorld.getCurrentWeather() != null ? this.mc.currentWorld.getCurrentWeather().getFogDistanceMultiplier() : 1.0f;
                fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.currentWorld.getWeatherManager().getWeatherIntensity() * this.mc.currentWorld.getWeatherManager().getWeatherPower();
                if (fogDistance > maxFogDistance * fogModifier) {
                    fogDistance = maxFogDistance * fogModifier;
                }
                if ((screen = this.mc.currentScreen) instanceof ScreenPhotoMode) {
                    ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
                    fogDistance = farPlaneDistance * screenPhotoMode.getFog(partialTick);
                }
                dest.fogMode = FogState.Mode.LINEAR;
                dest.fogStart = fogDistance * 0.25f * fogModifier;
                dest.fogEnd = fogDistance;
                dest.fogDensity = 1.0f;
                if (fogMode == -1) {
                    dest.fogStart = 0.0f;
                    dest.fogEnd = fogDistance * 0.8f;
                }
                if (!this.mc.currentWorld.getWorldType().hasTag(WorldTypeTags.NETHER)) break;
                dest.fogStart = 0.0f;
            }
        }
        return dest;
    }

    public void updateFogColor(float partialTick) {
        WorldClient world = this.mc.currentWorld;
        float renderDistanceScale = 1.0f / (float)(GameSettings.RENDER_DISTANCE.highest + 8 - (Integer)GameSettings.RENDER_DISTANCE.value);
        renderDistanceScale = 1.0f - (float)Math.pow(renderDistanceScale, 0.25);
        Vector3fc skyColor = world.getSkyColor(this.mc.activeCamera, partialTick);
        float rSky = skyColor.x();
        float gSky = skyColor.y();
        float bSky = skyColor.z();
        Vector3fc worldColor = world.getFogColor(this.mc.activeCamera, partialTick);
        this.fogRed = worldColor.x();
        this.fogGreen = worldColor.y();
        this.fogBlue = worldColor.z();
        this.fogRed += (rSky - this.fogRed) * renderDistanceScale;
        this.fogGreen += (gSky - this.fogGreen) * renderDistanceScale;
        this.fogBlue += (bSky - this.fogBlue) * renderDistanceScale;
        if (world.getCurrentWeather() != null) {
            float[] out = world.getCurrentWeather().modifyFogColor(this.fogRed, this.fogGreen, this.fogBlue, world.getWeatherManager().getWeatherIntensity() * world.getWeatherManager().getWeatherPower());
            this.fogRed = out[0];
            this.fogGreen = out[1];
            this.fogBlue = out[2];
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Materials.WATER, partialTick)) {
            if (this.mc.currentWorld != null && this.mc.currentWorld.getWorldType().hasTag(WorldTypeTags.NETHER)) {
                this.fogRed = 0.2f;
                this.fogGreen = 0.02f;
                this.fogBlue = 0.02f;
            } else {
                this.fogRed = 0.02f;
                this.fogGreen = 0.02f;
                this.fogBlue = 0.2f;
            }
            if (((Boolean)GameSettings.BIOME_WATER.value).booleanValue()) {
                TilePos cameraTile = this.mc.activeCamera.getTilePos();
                double temp = world.getBlockTemperature(cameraTile);
                double humid = world.getBlockHumidity(cameraTile);
                int waterColor = Colorizers.water.getColor(temp, humid);
                float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(waterColor & 0xFF) / 255.0f;
                red = MathHelper.clamp(red, 0.0f, 1.0f);
                green = MathHelper.clamp(green, 0.0f, 1.0f);
                blue = MathHelper.clamp(blue, 0.0f, 1.0f);
                this.fogRed = red * 0.5f;
                this.fogGreen = green * 0.5f;
                this.fogBlue = blue * 0.5f;
            }
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Materials.LAVA, partialTick)) {
            this.fogRed = 0.6f;
            this.fogGreen = 0.1f;
            this.fogBlue = 0.0f;
        }
        float brightness = this.fogBrightnessOld + (this.fogBrightness - this.fogBrightnessOld) * partialTick;
        this.fogRed *= brightness;
        this.fogGreen *= brightness;
        this.fogBlue *= brightness;
        Screen screen = this.mc.currentScreen;
        if (screen instanceof ScreenModelViewer) {
            ScreenModelViewer screenModelViewer = (ScreenModelViewer)screen;
            float[] color = screenModelViewer.getBackgroundFogColor();
            this.fogRed = color[0];
            this.fogGreen = color[1];
            this.fogBlue = color[2];
        }
        GL41.glClearColor(this.fogRed, this.fogGreen, this.fogBlue, 0.0f);
    }

    public static class FogState {
        @NotNull
        public final Vector4f fogColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        @NotNull
        public Mode fogMode = Mode.EXP;
        public float fogStart = 0.0f;
        public float fogEnd = 1.0f;
        public float fogDensity = 1.0f;

        public FogState() {
            this.reset();
        }

        @NotNull
        public FogState reset() {
            this.fogColor.set(0.0f, 0.0f, 0.0f);
            this.fogMode = Mode.EXP;
            this.fogStart = 0.0f;
            this.fogEnd = 1.0f;
            this.fogDensity = 1.0f;
            return this;
        }

        @NotNull
        public FogState disable() {
            this.fogMode = Mode.EXP;
            this.fogDensity = 0.0f;
            float maxFogDistance = GameSettings.RENDER_DISTANCE.highest * 16;
            this.fogStart = maxFogDistance * 0.25f;
            this.fogEnd = maxFogDistance;
            return this;
        }

        @NotNull
        public FogState copy() {
            FogState newState = new FogState();
            newState.fogColor.set(this.fogColor);
            newState.fogMode = this.fogMode;
            newState.fogStart = this.fogStart;
            newState.fogEnd = this.fogEnd;
            newState.fogDensity = this.fogDensity;
            return newState;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FogState) {
                FogState otherState = (FogState)obj;
                return otherState.fogColor.equals(this.fogColor) && otherState.fogStart == this.fogStart && otherState.fogEnd == this.fogEnd && otherState.fogMode == this.fogMode && otherState.fogDensity == this.fogDensity;
            }
            return false;
        }

        public static int uboSize() {
            return 32;
        }

        public static enum Mode {
            LINEAR,
            EXP,
            EXP2;

        }
    }
}

