/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.EntityLightning;
import org.jetbrains.annotations.NotNull;

public class EntityRendererLightningBolt
extends EntityRenderer<EntityLightning> {
    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull EntityLightning lightning, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR_WORLD);
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE);
        double @NotNull [] xOffs = new double[8];
        double @NotNull [] zOffs = new double[8];
        double xOff = 0.0;
        double zOff = 0.0;
        @NotNull Random random = new Random(lightning.seed);
        for (int h = 7; h >= 0; --h) {
            xOffs[h] = xOff;
            zOffs[h] = zOff;
            xOff += (double)(random.nextInt(11) - 5);
            zOff += (double)(random.nextInt(11) - 5);
        }
        for (int r = 0; r < 4; ++r) {
            random.setSeed(lightning.seed);
            for (int p = 0; p < 3; ++p) {
                int hs = 7;
                int ht = 0;
                if (p > 0) {
                    hs = 7 - p;
                    ht = hs - 2;
                }
                double xo0 = xOffs[hs] - xOff;
                double zo0 = zOffs[hs] - zOff;
                for (int h = hs; h >= ht; --h) {
                    double xo1 = xo0;
                    double zo1 = zo0;
                    if (p == 0) {
                        xo0 += (double)(random.nextInt(11) - 5);
                        zo0 += (double)(random.nextInt(11) - 5);
                    } else {
                        xo0 += (double)(random.nextInt(31) - 15);
                        zo0 += (double)(random.nextInt(31) - 15);
                    }
                    tessellator.startDrawing(DrawMode.TRIANGLE_STRIP);
                    float br = 0.5f;
                    tessellator.setColor4f(lightning.r * 0.5f, lightning.g * 0.5f, lightning.b * 0.5f, 0.3f);
                    double rr1 = 0.1 + (double)r * 0.2;
                    if (p == 0) {
                        rr1 *= (double)h * 0.1 + 1.0;
                    }
                    double rr2 = 0.1 + (double)r * 0.2;
                    if (p == 0) {
                        rr2 *= (double)(h - 1) * 0.1 + 1.0;
                    }
                    for (int s = 0; s < 5; ++s) {
                        double xos1 = 0.5 - rr1;
                        double zos1 = 0.5 - rr1;
                        if (s == 1 || s == 2) {
                            xos1 += rr1 * 2.0;
                        }
                        if (s == 2 || s == 3) {
                            zos1 += rr1 * 2.0;
                        }
                        double xos2 = 0.5 - rr2;
                        double zos2 = 0.5 - rr2;
                        if (s == 1 || s == 2) {
                            xos2 += rr2 * 2.0;
                        }
                        if (s == 2 || s == 3) {
                            zos2 += rr2 * 2.0;
                        }
                        if (lightning.flipped) {
                            tessellator.addVertex(xos2 + xo0, (h - hs) * 16, zos2 + zo0);
                            tessellator.addVertex(xos1 + xo1, (h - hs + 1) * 16, zos1 + zo1);
                            continue;
                        }
                        tessellator.addVertex(xos2 + xo0, h * 16, zos2 + zo0);
                        tessellator.addVertex(xos1 + xo1, (h + 1) * 16, zos1 + zo1);
                    }
                    GLRenderer.pushFrame();
                    GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
                    GLRenderer.modelM4f().rotate(lightning.yaw, 0.0f, 1.0f, 0.0f);
                    GLRenderer.modelM4f().rotate(lightning.pitch, 1.0f, 0.0f, 0.0f);
                    GLRenderer.modelM4f().scale(lightning.scale, lightning.scale, lightning.scale);
                    tessellator.draw();
                    GLRenderer.popFrame();
                }
            }
        }
        GLRenderer.disableState(State.BLEND);
        GLRenderer.globalSetLightEnabled(true);
        GLRenderer.popFrame();
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
    }
}

