/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Option<E> {
    @NotNull
    public final String id;
    @NotNull
    public E value;
    @NotNull
    protected final E defaultValue;
    @Nullable
    protected DisplayStringProvider<E> displayStringProvider;
    protected final List<OptionCallback<E>> onChangeCallbacks = new ArrayList<OptionCallback<E>>();

    public Option(@NotNull String id, @NotNull E defaultValue) {
        this.id = id;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    public void set(@NotNull E value) {
        this.value = value;
    }

    @NotNull
    public <T extends Option<E>> T addOnChangeCallback(@NotNull OptionCallback<E> callback) {
        this.onChangeCallbacks.add(callback);
        return (T)this;
    }

    @NotNull
    public <T extends Option<E>> T withDisplayStringProvider(@NotNull DisplayStringProvider<E> provider) {
        this.displayStringProvider = provider;
        return (T)this;
    }

    public abstract void fromOptionsString(@NotNull String var1);

    public void onUpdate() {
        for (OptionCallback<E> callback : this.onChangeCallbacks) {
            callback.onUpdate(Minecraft.getMinecraft(), this);
        }
    }

    @NotNull
    public String getDisplayString() {
        if (this.displayStringProvider != null) {
            return this.displayStringProvider.getDisplayString(Minecraft.getMinecraft(), I18n.getInstance(), this);
        }
        return this.toOptionsString();
    }

    @NotNull
    public String getDisplayStringValue() {
        return this.getDisplayString();
    }

    @NotNull
    public String getDisplayStringName() {
        return I18n.getInstance().translateKey("options." + this.id);
    }

    @NotNull
    public String toOptionsString() {
        return Util.emptyStringIfNull(this.value.toString());
    }

    @NotNull
    public E getDefaultValue() {
        return this.defaultValue;
    }

    public static interface DisplayStringProvider<T> {
        @NotNull
        public String getDisplayString(@NotNull Minecraft var1, @NotNull I18n var2, @NotNull Option<T> var3);
    }

    public static interface OptionCallback<T> {
        public void onUpdate(@NotNull Minecraft var1, @NotNull Option<T> var2);
    }
}

