/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLever<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public StaticBlockModel active = BlockModelDispatcher.loadDataModel("minecraft:block/lever_active").asModel();

    public BlockModelGenericLever(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/lever_idle"));
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int data = worldSource.getBlockData(tilePos);
        int rotation = data & 0xF;
        return switch (rotation) {
            case 1 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 2 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 3 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 4 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 1, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 5 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 6 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 7 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 2, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 8 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 2, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            default -> super.renderAttached(tessellator, worldSource, tilePos, cullFaces, overrideTexture);
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        boolean powered = (data & 0x10) != 0;
        return powered ? this.active : this.staticModel;
    }
}

