/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import net.minecraft.client.gui.toasts.IToastable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicToast
implements IToastable {
    private static final double ANIMATION_DURATION_MILLIS = 6000.0;
    private long startTime;
    @NotNull
    private final String title;
    @Nullable
    private final String author;

    public MusicToast(@NotNull String title, @Nullable String author) {
        this.title = title;
        this.author = author;
    }

    @Override
    public boolean messageOnly(long runtime) {
        return this.author == null;
    }

    @Override
    public String getTitle(long runtime) {
        return this.title;
    }

    @Override
    public int titleColor(long runtime) {
        return -1;
    }

    @Override
    public String getMessage(long runtime) {
        if (this.author == null) {
            return this.title;
        }
        return this.author;
    }

    @Override
    public int messageColor(long runtime) {
        if (this.author == null) {
            return -1;
        }
        return -5263441;
    }

    @Override
    public double getAnimationProgress(long runtime) {
        runtime = System.currentTimeMillis() - this.startTime;
        return (double)runtime / 6000.0;
    }

    @Override
    public String getTexture(long runtime) {
        return "minecraft:gui/toast_music";
    }

    @Override
    public void onToastStart() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void onToastEnd() {
    }

    @Override
    public boolean isEquivalentToast(@NotNull IToastable toast) {
        return toast instanceof MusicToast;
    }

    @Override
    @Nullable
    public ItemStack getIcon(long runtime) {
        return Items.RECORD_CAT.getDefaultStack();
    }
}

