/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.Minecraft;
import net.minecraft.client.option.OptionToggleable;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.ITranslatable;
import net.minecraft.core.util.helper.Toggleable;
import org.jetbrains.annotations.NotNull;

public class OptionEnum<E extends Enum<?>>
extends OptionToggleable<E>
implements Toggleable {
    private boolean isSlider;

    public OptionEnum(@NotNull String name, @NotNull Class<E> clazz) {
        this(name, clazz, ((Enum[])clazz.getEnumConstants())[0]);
    }

    public OptionEnum(@NotNull String name, @NotNull Class<E> clazz, @NotNull E defaultValue) {
        super(name, defaultValue, (Enum[])clazz.getEnumConstants());
    }

    @Override
    public void fromOptionsString(@NotNull String string) {
        for (Enum e : (Enum[])this.values) {
            if (!e.toString().equalsIgnoreCase(string)) continue;
            this.value = e;
        }
    }

    public OptionEnum<E> setIsSlider(boolean isSlider) {
        this.isSlider = isSlider;
        return this;
    }

    @Override
    public boolean isSlider() {
        return this.isSlider;
    }

    @Override
    @NotNull
    public String getDisplayString() {
        String key;
        I18n i18n = I18n.getInstance();
        if (this.displayStringProvider != null) {
            return this.displayStringProvider.getDisplayString(Minecraft.getMinecraft(), i18n, this);
        }
        Object object = this.value;
        if (object instanceof ITranslatable) {
            ITranslatable translatable = (ITranslatable)object;
            key = translatable.getTranslationKey();
        } else {
            key = ((Enum)this.value).toString().toLowerCase();
        }
        return i18n.translateKey("options." + this.id + "." + key);
    }
}

