/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDye
extends Item {
    public ItemDye(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    @NotNull
    public String getLanguageKey(@NotNull ItemStack selfStack) {
        return super.getKey() + "." + DyeColor.colorFromItemMeta((int)selfStack.getMetadata()).colorID;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xPlaced, double yPlaced) {
        TileEntity tileEntity;
        Block<?> block = world.getBlockType(blockPos);
        if (Block.hasLogicClass(block, BlockLogicSign.class) && (tileEntity = world.getTileEntity(blockPos)) instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            if (DyeColor.WHITE.itemMeta - selfStack.getMetadata() != sign.getColor().id) {
                sign.setColor(TextFormatting.get(DyeColor.WHITE.itemMeta - selfStack.getMetadata()));
                if (player == null || player.getGamemode().hasBlockConsumption()) {
                    --selfStack.stackSize;
                }
                return true;
            }
            return false;
        }
        if (selfStack.getMetadata() == DyeColor.WHITE.itemMeta) {
            Block<?> grass;
            IBonemealable bonemealable;
            TilePos queryPos = new TilePos();
            BlockLogic blockLogic = Block.getLogicClass(block);
            if (blockLogic instanceof IBonemealable && (bonemealable = (IBonemealable)((Object)blockLogic)).onBonemealUsed(selfStack, player, world, blockPos, side, xPlaced, yPlaced)) {
                return true;
            }
            if (block == Blocks.DIRT) {
                if (!world.isClientSide && world.getBlockType(blockPos.up(queryPos)).lightBlock() <= 2) {
                    grass = Blocks.GRASS;
                    if (world.getDimensionData().getWorldType().hasTag(WorldTypeTags.RETRO)) {
                        grass = Blocks.GRASS_RETRO;
                    }
                    world.setBlockTypeNotify(blockPos, grass);
                    if (player == null || player.getGamemode().hasBlockConsumption()) {
                        --selfStack.stackSize;
                    }
                }
                return true;
            }
            if (block == Blocks.DIRT_SCORCHED) {
                if (!world.isClientSide && world.getBlockType(blockPos.up(queryPos)).lightBlock() <= 2) {
                    grass = Blocks.GRASS_SCORCHED;
                    world.setBlockTypeNotify(blockPos, grass);
                    if (player == null || player.getGamemode().hasBlockConsumption()) {
                        --selfStack.stackSize;
                    }
                }
                return true;
            }
            if (block != null && block.hasTag(BlockTags.GROWS_FLOWERS)) {
                if (!world.isClientSide) {
                    if (player == null || player.getGamemode().hasBlockConsumption()) {
                        --selfStack.stackSize;
                    }
                    TilePos p = new TilePos(blockPos);
                    block0: for (int j1 = 0; j1 < 128; ++j1) {
                        p.set(blockPos.x(), blockPos.y() + 1, blockPos.z());
                        for (int j2 = 0; j2 < j1 / 16; ++j2) {
                            p.x += itemRand.nextInt(3) - 1;
                            p.y += (itemRand.nextInt(3) - 1) * itemRand.nextInt(3) / 2;
                            p.z += itemRand.nextInt(3) - 1;
                            if (!world.getBlockType(p.down(queryPos)).hasTag(BlockTags.GROWS_FLOWERS)) continue block0;
                        }
                        if (world.getBlockType(p) != Blocks.AIR) continue;
                        if (itemRand.nextInt(10) != 0) {
                            if (world.getBlockType(p.down(queryPos)) == Blocks.DIRT_SCORCHED || world.getBlockType(p.down(queryPos)) == Blocks.DIRT_SCORCHED_RICH) {
                                world.setBlockTypeNotify(p, Blocks.SPINIFEX);
                                continue;
                            }
                            world.setBlockTypeNotify(p, Blocks.TALLGRASS);
                            continue;
                        }
                        int r = itemRand.nextInt(12);
                        Biome biome = world.getBlockBiome(p);
                        if (r < 1) {
                            world.setBlockTypeNotify(p, Blocks.FLOWER_YELLOW);
                            continue;
                        }
                        if (r < 2) {
                            world.setBlockTypeNotify(p, Blocks.FLOWER_RED);
                            continue;
                        }
                        if (r < 4 && (biome == Biomes.OVERWORLD_BIRCH_FOREST || biome == Biomes.OVERWORLD_SEASONAL_FOREST)) {
                            world.setBlockTypeNotify(p, Blocks.FLOWER_PINK);
                            continue;
                        }
                        if (r < 6 && (biome == Biomes.OVERWORLD_MEADOW || biome == Biomes.OVERWORLD_BOREAL_FOREST || biome == Biomes.OVERWORLD_SHRUBLAND)) {
                            world.setBlockTypeNotify(p, Blocks.FLOWER_PURPLE);
                            continue;
                        }
                        if (r < 8 && (biome == Biomes.OVERWORLD_FOREST || biome == Biomes.OVERWORLD_SWAMPLAND || biome == Biomes.OVERWORLD_RAINFOREST || biome == Biomes.OVERWORLD_GRASSLANDS || biome == Biomes.OVERWORLD_CAATINGA)) {
                            world.setBlockTypeNotify(p, Blocks.FLOWER_LIGHT_BLUE);
                            continue;
                        }
                        if (r >= 10 || biome != Biomes.OVERWORLD_PLAINS && biome != Biomes.OVERWORLD_GRASSLANDS && biome != Biomes.OVERWORLD_OUTBACK && biome != Biomes.OVERWORLD_OUTBACK_GRASSY) continue;
                        world.setBlockTypeNotify(p, Blocks.FLOWER_ORANGE);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        this.onUseOnBlock(selfStack, world, null, blockPos.add(direction, new TilePos()), direction.getSide(), 0.5, 0.5);
    }

    @Override
    public boolean useOnEntity(@NotNull ItemStack selfStack, @NotNull Player player, @NotNull Mob mob) {
        if (mob instanceof MobSheep) {
            MobSheep mobSheep = (MobSheep)mob;
            DyeColor woolColor = DyeColor.colorFromItemMeta(selfStack.getMetadata());
            if (mobSheep.getFleeceColor() != woolColor && selfStack.consumeItem(player)) {
                mobSheep.setFleeceColor(woolColor);
                return true;
            }
        }
        return false;
    }
}

