/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import org.jetbrains.annotations.NotNull;

public final class SurfaceProperties {
    @NotNull
    private final Block<?> topBlock;
    @NotNull
    private final Block<?> fillerBlock;

    private SurfaceProperties(@NotNull Block<?> topBlock, @NotNull Block<?> fillerBlock) {
        this.topBlock = topBlock;
        this.fillerBlock = fillerBlock;
    }

    @NotNull
    public Block<?> getTopBlock() {
        return this.topBlock;
    }

    @NotNull
    public Block<?> getFillerBlock() {
        return this.fillerBlock;
    }

    public static final class Builder {
        @NotNull
        private Block<?> topBlock = Blocks.GRASS;
        @NotNull
        private Block<?> fillerBlock = Blocks.DIRT;

        @NotNull
        public Block<?> getTopBlock() {
            return this.topBlock;
        }

        @NotNull
        public Builder withTopBlock(@NotNull Block<?> block) {
            this.topBlock = block;
            return this;
        }

        @NotNull
        public Block<?> getFillerBlock() {
            return this.fillerBlock;
        }

        @NotNull
        public Builder withFillerBlock(@NotNull Block<?> block) {
            this.fillerBlock = block;
            return this;
        }

        @NotNull
        public SurfaceProperties build() {
            return new SurfaceProperties(this.topBlock, this.fillerBlock);
        }
    }
}

