/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericChest<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel left;
    @NotNull
    public final StaticBlockModel right;

    public BlockModelGenericChest(@NotNull Block<T> block, @NotNull BlockModelData single, @NotNull BlockModelData left, @NotNull BlockModelData right) {
        super(block, single);
        this.left = left.asModel();
        this.right = right.asModel();
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        Direction direction = BlockLogicChest.getDirectionFromMeta(worldSource.getBlockData(tilePos));
        switch (direction) {
            case NORTH: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case WEST: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case EAST: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
            case SOUTH: {
                return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            }
        }
        return this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta(source.getBlockData(tilePosc));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BlockLogicChest.Type.LEFT -> this.left;
            case BlockLogicChest.Type.RIGHT -> this.right;
            case BlockLogicChest.Type.SINGLE -> this.staticModel;
        };
    }
}

