/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;

public abstract class EntityCamera
implements ICamera {
    @NotNull
    protected final Minecraft mc;
    @NotNull
    private final CameraFrustum frustum;
    @NotNull
    public final Mob mob;
    private double hhO = Double.NaN;

    public EntityCamera(@NotNull Minecraft mc, @NotNull Mob mob) {
        this.mc = mc;
        this.mob = mob;
        this.frustum = new CameraFrustum(this);
    }

    @Override
    public boolean showPlayer() {
        return false;
    }

    @Override
    public void tick() {
        this.hhO = this.mob.getHeadHeight();
    }

    @Override
    public void applyGlTransformations() {
    }

    @Override
    public double getX(float partialTick) {
        if (partialTick == 1.0f || this.mob.isRemoved()) {
            return this.mob.x;
        }
        return this.mob.xo + (this.mob.x - this.mob.xo) * (double)partialTick;
    }

    @Override
    public double getY(float partialTick) {
        if (partialTick == 1.0f || this.mob.isRemoved()) {
            return this.mob.y + (double)this.mob.getHeadHeight();
        }
        if (!Double.isFinite(this.hhO)) {
            this.hhO = this.mob.getHeadHeight();
        }
        return this.mob.yo + (this.mob.y - this.mob.yo) * (double)partialTick + MathHelper.lerp(this.hhO, (double)this.mob.getHeadHeight(), (double)partialTick);
    }

    @Override
    public double getZ(float partialTick) {
        if (partialTick == 1.0f || this.mob.isRemoved()) {
            return this.mob.z;
        }
        return this.mob.zo + (this.mob.z - this.mob.zo) * (double)partialTick;
    }

    @Override
    public double getXRot(float partialTick) {
        if (partialTick == 1.0f || this.mob.isRemoved()) {
            return this.mob.xRot;
        }
        return this.mob.xRotO + (this.mob.xRot - this.mob.xRotO) * partialTick;
    }

    @Override
    public double getYRot(float partialTick) {
        if (partialTick == 1.0f || this.mob.isRemoved()) {
            return this.mob.yRot;
        }
        return this.mob.yRotO + (this.mob.yRot - this.mob.yRotO) * partialTick;
    }

    @Override
    public double getFov() {
        return GameSettings.FOV.get();
    }

    @Override
    @NotNull
    public CameraFrustum getFrustum() {
        return this.frustum;
    }
}

