/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.client.render.ImageParser;

public class PlayerSkinParser
implements ImageParser {
    public static final BufferedImage maskImageSteve;
    public static final BufferedImage maskImageAlex;
    public static final PlayerSkinParser instanceSteve;
    public static final PlayerSkinParser instanceAlex;
    private int[] imageData;
    private final int width = 64;
    private final int height = 64;
    private final boolean slim;

    public PlayerSkinParser(boolean slim) {
        this.slim = slim;
    }

    @Override
    public BufferedImage parseImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        BufferedImage newImage = new BufferedImage(64, 64, 2);
        Graphics g = newImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        if (image.getHeight() == 32) {
            g.drawImage(image, 24, 52, 20, 64, 4, 20, 8, 32, null);
            g.drawImage(image, 32, 52, 28, 64, 12, 20, 16, 32, null);
            g.drawImage(image, 28, 52, 24, 64, 0, 20, 4, 32, null);
            g.drawImage(image, 20, 52, 16, 64, 8, 20, 12, 32, null);
            g.drawImage(image, 24, 48, 20, 52, 4, 16, 8, 20, null);
            g.drawImage(image, 28, 48, 24, 52, 8, 16, 12, 20, null);
            g.drawImage(image, 40, 52, 36, 64, 44, 20, 48, 32, null);
            g.drawImage(image, 48, 52, 44, 64, 52, 20, 56, 32, null);
            g.drawImage(image, 44, 52, 40, 64, 40, 20, 44, 32, null);
            g.drawImage(image, 36, 52, 32, 64, 48, 20, 52, 32, null);
            g.drawImage(image, 40, 48, 36, 52, 44, 16, 48, 20, null);
            g.drawImage(image, 44, 48, 40, 52, 48, 16, 52, 20, null);
        }
        g.dispose();
        this.imageData = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
        this.removeTransparency();
        return newImage;
    }

    private void removeTransparency() {
        BufferedImage mask = this.slim ? maskImageAlex : maskImageSteve;
        int x = 0;
        while (true) {
            Objects.requireNonNull(this);
            if (x >= 64) break;
            int y = 0;
            while (true) {
                Objects.requireNonNull(this);
                if (y >= 64) break;
                Objects.requireNonNull(this);
                int n = x + y * 64;
                this.imageData[n] = this.imageData[n] | (mask.getRGB(x, y) & 0xFF) << 24;
                ++y;
            }
            ++x;
        }
    }

    static {
        try {
            maskImageSteve = ImageIO.read(PlayerSkinParser.class.getResourceAsStream("/assets/minecraft/textures/entity/char/mask_steve.png"));
            maskImageAlex = ImageIO.read(PlayerSkinParser.class.getResourceAsStream("/assets/minecraft/textures/entity/char/mask_alex.png"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        instanceSteve = new PlayerSkinParser(false);
        instanceAlex = new PlayerSkinParser(true);
    }
}

