/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericTrapdoorPainted<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final StaticBlockModel[] bottom = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] open = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] top = new StaticBlockModel[16];

    public BlockModelGenericTrapdoorPainted(@NotNull Block<T> block) {
        super(block, BlockModelDispatcher.loadDataModel("minecraft:block/trapdoor/planks/white/bottom"));
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            this.bottom[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/trapdoor/planks/" + color.colorID + "/bottom").asModel();
            this.open[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/trapdoor/planks/" + color.colorID + "/open").asModel();
            this.top[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/trapdoor/planks/" + color.colorID + "/top").asModel();
        }
    }

    @Override
    public boolean renderAttached(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        int rotation = worldSource.getBlockData(tilePos) & 3;
        return switch (rotation & 3) {
            case 1 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 2 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            case 3 -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
            default -> this.getModel(worldSource, tilePos).renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, cullFaces, overrideTexture);
        };
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        int color = data >> 4 & 0xF;
        if ((data & 4) != 0) {
            return this.open[color];
        }
        if ((data & 8) != 0) {
            return this.top[color];
        }
        return this.bottom[color];
    }
}

