/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.colorizer.ColorMap;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import org.jetbrains.annotations.NotNull;

public class Colorizer {
    public final String name;
    private final ColorMap currentColor = new ColorMap();
    private ColorMap defaultColor;
    private TexturePack texturePack;

    public Colorizer(String name) {
        this.name = name;
    }

    public void setup(@NotNull Minecraft minecraft, List<Season> seasons) {
        this.texturePack = null;
        if (minecraft.currentWorld == null) {
            return;
        }
        String path = null;
        WorldType worldType = minecraft.currentWorld.getWorldType();
        if (worldType == WorldTypes.OVERWORLD_HELL) {
            path = "/assets/minecraft/textures/colormap/" + this.name + "/hell.png";
            this.texturePack = Colorizers.findTexturePackWithFile(minecraft, path);
        }
        if (worldType == WorldTypes.OVERWORLD_WINTER) {
            path = "/assets/minecraft/textures/colormap/" + this.name + "/winter.png";
            this.texturePack = Colorizers.findTexturePackWithFile(minecraft, path);
        }
        if (this.texturePack == null) {
            Dimension dimension = minecraft.currentWorld.dimension;
            String dimensionName = dimension.languageKey.replace('.', '_').toLowerCase();
            path = "/assets/minecraft/textures/colormap/" + this.name + "/" + dimensionName + ".png";
            this.texturePack = Colorizers.findTexturePackWithFile(minecraft, path);
        }
        if (this.texturePack == null) {
            path = "/assets/minecraft/textures/colormap/" + this.name + "/default.png";
            this.texturePack = Colorizers.findTexturePackWithFile(minecraft, path);
        }
        if (this.texturePack == null) {
            return;
        }
        this.defaultColor = Colorizers.loadColorData(this.texturePack, path);
        if (this.defaultColor == null) {
            throw new NullPointerException("Could not load colormap '" + path + "' from asset pack '" + this.texturePack.fileName + "'!");
        }
    }

    public ColorMap loadColormap(Dimension dimension, Season season) {
        if (season == null || season == Seasons.NULL) {
            return this.defaultColor;
        }
        String seasonName = season.getId().replace('.', '_').toLowerCase();
        String seasonPath = "/assets/minecraft/textures/colormap/" + this.name + "/" + seasonName + ".png";
        ColorMap seasonColor = Colorizers.loadColorData(this.texturePack, seasonPath);
        if (seasonColor != null) {
            return seasonColor;
        }
        return this.defaultColor;
    }

    public void update(Dimension dimension, Season season1, Season season2, float blendFactor) {
        ColorMap colorMap2;
        if (!this.isEnabled()) {
            return;
        }
        ColorMap colorMap1 = this.loadColormap(dimension, season1);
        if (colorMap1 == (colorMap2 = this.loadColormap(dimension, season2))) {
            this.update(colorMap1);
        } else {
            this.update(colorMap1, colorMap2, blendFactor);
        }
    }

    public void update(ColorMap colorMap) {
        System.arraycopy(colorMap.buffer, 0, this.currentColor.buffer, 0, this.currentColor.buffer.length);
    }

    public void update(ColorMap colorMap1, ColorMap colorMap2, float blendFactor) {
        for (int i = 0; i < this.currentColor.buffer.length; ++i) {
            this.currentColor.buffer[i] = Colorizer.blendColor(colorMap1.buffer[i], colorMap2.buffer[i], blendFactor);
        }
    }

    public int getDefaultColor(double temperature, double humidity) {
        if (!this.isEnabled()) {
            return -1;
        }
        return this.defaultColor.getColor(temperature, humidity);
    }

    public int getColor(WorldSource world, @NotNull TilePosc tilePos) {
        if (!this.isEnabled()) {
            return -1;
        }
        double temperature = world.getBlockTemperature(tilePos);
        double humidity = world.getBlockHumidity(tilePos);
        return this.getColor(temperature, humidity);
    }

    public int getColor(double temperature, double humidity) {
        if (!this.isEnabled()) {
            return -1;
        }
        return this.currentColor.getColor(temperature, humidity);
    }

    public boolean isEnabled() {
        return this.texturePack != null;
    }

    public TexturePack getTexturePack() {
        return this.texturePack;
    }

    public static int blendColor(int color1, int color2, float blend) {
        float blend1 = 1.0f - blend;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 >> 0 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 >> 0 & 0xFF;
        int r = (int)((float)r1 * blend1 + (float)r2 * blend);
        int g = (int)((float)g1 * blend1 + (float)g2 * blend);
        int b = (int)((float)b1 * blend1 + (float)b2 * blend);
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        return r << 16 | g << 8 | b;
    }
}

