/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;

public class EntityRendererArrow
extends EntityRenderer<ProjectileArrow> {
    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull ProjectileArrow arrow, double x, double y, double z, float yaw, float partialTick) {
        double toDeath;
        int pastPrime;
        int prime = 900;
        if ((float)arrow.ticksInGround + partialTick > (float)prime && Math.cos((double)((float)(pastPrime = arrow.ticksInGround - prime) + partialTick) * Math.PI / (2.5 + 5.5 * (toDeath = 1.0 - (double)((float)pastPrime + partialTick) * 4.0 / 1200.0))) > 0.0) {
            return;
        }
        this.bindTexture("/assets/minecraft/textures/entity/arrows.png");
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        GLRenderer.modelM4f().rotateY(org.joml.Math.toRadians(org.joml.Math.lerp(arrow.yRotO, arrow.yRot, partialTick) - 90.0f));
        GLRenderer.modelM4f().rotateZ(org.joml.Math.toRadians(org.joml.Math.lerp(arrow.xRotO, arrow.xRot, partialTick)));
        int arrowType = arrow.getArrowType();
        float bodyMinU = 0.0f;
        float bodyMaxU = 0.5f;
        float bodyMinV = (float)(arrowType * 10) / 32.0f;
        float bodyMaxV = (float)(5 + arrowType * 10) / 32.0f;
        float tailMinU = 0.0f;
        float tailMaxU = 0.15625f;
        float tailMinV = (float)(5 + arrowType * 10) / 32.0f;
        float tailMaxV = (float)(10 + arrowType * 10) / 32.0f;
        float scale = 0.05625f;
        float shakeAmount = (float)arrow.shake - partialTick;
        if (shakeAmount > 0.0f) {
            float shakeAngle = -MathHelper.sin(shakeAmount * 3.0f) * shakeAmount;
            GLRenderer.modelM4f().rotateZ(org.joml.Math.toRadians(shakeAngle));
        }
        GLRenderer.modelM4f().rotateX(org.joml.Math.toRadians(45.0f));
        GLRenderer.modelM4f().scale(scale, scale, scale);
        GLRenderer.modelM4f().translate(-4.0f, 0.0f, 0.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, tailMinU, tailMinV);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, tailMaxU, tailMinV);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, tailMaxU, tailMaxV);
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, tailMinU, tailMaxV);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-7.0, 2.0, -2.0, tailMinU, tailMinV);
        tessellator.addVertexWithUV(-7.0, 2.0, 2.0, tailMaxU, tailMinV);
        tessellator.addVertexWithUV(-7.0, -2.0, 2.0, tailMaxU, tailMaxV);
        tessellator.addVertexWithUV(-7.0, -2.0, -2.0, tailMinU, tailMaxV);
        tessellator.draw();
        for (int i = 0; i < 4; ++i) {
            GLRenderer.modelM4f().rotateX(1.5707964f);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-8.0, -2.0, 0.0, bodyMinU, bodyMinV);
            tessellator.addVertexWithUV(8.0, -2.0, 0.0, bodyMaxU, bodyMinV);
            tessellator.addVertexWithUV(8.0, 2.0, 0.0, bodyMaxU, bodyMaxV);
            tessellator.addVertexWithUV(-8.0, 2.0, 0.0, bodyMinU, bodyMaxV);
            tessellator.draw();
        }
        GLRenderer.popFrame();
    }
}

