/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import com.mojang.logging.LogUtils;
import java.nio.ByteBuffer;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.tessellator.RenderBuffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class TessellatorAurora {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VERT_SIZE = 40;
    private boolean quadEmulation = false;
    @NotNull
    public final String name;
    @NotNull
    public ByteBuffer data;
    protected double offsetX;
    protected double offsetY;
    protected double offsetZ;
    @NotNull
    public DrawMode drawMode = DrawMode.TRIANGLES;
    public boolean drawing;
    public int vertexCount;
    private int quadVertCount = 0;

    public TessellatorAurora(@NotNull String name, int initialCapacity) {
        this.name = name;
        this.data = BufferUtils.createByteBuffer(initialCapacity);
    }

    public void startDrawing(@NotNull DrawMode drawMode) {
        if (this.drawing) {
            this.drawing = false;
            throw new IllegalStateException(this.name + "Already drawing!");
        }
        if (drawMode == DrawMode.QUADS) {
            this.drawMode = DrawMode.TRIANGLES;
            this.quadEmulation = true;
        } else {
            this.drawMode = drawMode;
        }
        this.drawing = true;
        this.vertexCount = 0;
        this.quadVertCount = 0;
        this.data.clear();
    }

    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException(this.name + " not drawing!");
        }
    }

    public void checkCanFit(int size) {
        if (this.data.capacity() < this.data.position() + size) {
            int newSize = this.data.capacity() * 2;
            LOGGER.info("Expanding {} Buffer ({} -> {})", this.name, this.data.capacity(), newSize);
            ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
            this.data.flip();
            newBuffer.put(this.data);
            this.data = newBuffer;
        }
    }

    public void addVertex(double x, double y, double z, double xo, double yo, double zo, float r, float g, float b, float a, float ro, float go, float bo, float ao, float u, float v) {
        this.checkIsDrawing();
        this.checkCanFit(128);
        this.data.putFloat((float)(x + this.offsetX)).putFloat((float)(y + this.offsetY)).putFloat((float)(z + this.offsetZ));
        this.data.putFloat((float)(xo + this.offsetX)).putFloat((float)(yo + this.offsetY)).putFloat((float)(zo + this.offsetZ));
        this.data.putInt(((int)(a * 255.0f) & 0xFF) << 24 | ((int)(b * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(r * 255.0f) & 0xFF);
        this.data.putInt(((int)(ao * 255.0f) & 0xFF) << 24 | ((int)(bo * 255.0f) & 0xFF) << 16 | ((int)(go * 255.0f) & 0xFF) << 8 | (int)(ro * 255.0f) & 0xFF);
        this.data.putFloat(u).putFloat(v);
        ++this.vertexCount;
        if (this.quadEmulation && this.quadVertCount % 4 == 2) {
            int vertSize = 40;
            this.checkCanFit(256);
            this.data.put(this.data.position(), this.data, this.data.position() - vertSize * 3, vertSize);
            this.data.put(this.data.position() + vertSize, this.data, this.data.position() - vertSize, vertSize);
            this.data.position(this.data.position() + vertSize * 2);
            this.vertexCount += 2;
        }
        ++this.quadVertCount;
    }

    @NotNull
    public RenderBuffer record(int vao, int vbo) {
        this.checkIsDrawing();
        this.drawing = false;
        this.enable(vao, vbo);
        GL41.glBufferData(34962, this.data.flip(), 35044);
        GL41.glBindVertexArray(0);
        return new RenderBuffer(vao, vbo, 0, this.vertexCount, this.drawMode);
    }

    public void enable(int vao, int vbo) {
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        int offset = 0;
        GL41.glVertexAttribPointer(0, 3, 5126, false, 40, offset);
        GL41.glVertexAttribPointer(1, 3, 5126, false, 40, offset += 12);
        GL41.glVertexAttribPointer(2, 4, 5121, true, 40, offset += 12);
        GL41.glVertexAttribPointer(3, 4, 5121, true, 40, offset += 4);
        GL41.glVertexAttribPointer(4, 2, 5126, false, 40, offset += 4);
        offset += 2;
        GL41.glEnableVertexAttribArray(0);
        GL41.glEnableVertexAttribArray(1);
        GL41.glEnableVertexAttribArray(2);
        GL41.glEnableVertexAttribArray(3);
        GL41.glEnableVertexAttribArray(4);
    }
}

