/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketSetMobSpawner
extends Packet {
    public TilePos tilePos;
    @Nullable
    public EntityDispatcher.EntityDispatcherEntry<?> dispatcherEntry;

    public PacketSetMobSpawner() {
        this.isChunkDataPacket = true;
    }

    public PacketSetMobSpawner(@NotNull TilePos tilePos, @Nullable EntityDispatcher.EntityDispatcherEntry<?> dispatcherEntry) {
        this.isChunkDataPacket = true;
        this.tilePos = tilePos;
        this.dispatcherEntry = dispatcherEntry;
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.tilePos = new TilePos(dis.readInt(), dis.readShort(), dis.readInt());
        int type = dis.readShort() & 0xFFFF;
        this.dispatcherEntry = type == 65535 ? null : EntityDispatcher.getInstance().entryForNumericId(type);
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.tilePos.x);
        dos.writeShort(this.tilePos.y);
        dos.writeInt(this.tilePos.z);
        if (this.dispatcherEntry != null) {
            dos.writeShort(this.dispatcherEntry.numericID);
        } else {
            dos.writeShort(65535);
        }
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleSetMobSpawner(this);
    }

    @Override
    public int getEstimatedSize() {
        return 14;
    }
}

