/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.BiomeTags;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.weather.WeatherConfig;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;

public abstract class Weather {
    private final int id;
    @NotNull
    private final String languageKey;
    private final int lightLevelSubtracted;
    private final boolean mobDaylightSpawnAllowed;
    private final boolean isDamp;
    private final float fogDistanceMultiplier;

    public Weather(int id, @NotNull String languageKey, @NotNull WeatherConfig weatherConfig) {
        this.id = id;
        this.languageKey = "weather." + languageKey;
        this.lightLevelSubtracted = weatherConfig.getLightLevelSubtracted();
        this.mobDaylightSpawnAllowed = weatherConfig.isMobDaylightSpawnAllowed();
        this.isDamp = weatherConfig.isDamp();
        this.fogDistanceMultiplier = weatherConfig.getFogDistanceMultiplier();
        if (Weathers.WEATHERS[id] != null) {
            throw new RuntimeException();
        }
        Weathers.WEATHERS[id] = this;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getLanguageKey() {
        return this.languageKey;
    }

    @NotNull
    public final String getNameLanguageKey() {
        return this.languageKey + ".name";
    }

    public final int getLightLevelSubtracted() {
        return this.lightLevelSubtracted;
    }

    public final boolean isMobDaylightSpawnAllowed() {
        return this.mobDaylightSpawnAllowed;
    }

    public final boolean isDamp() {
        return this.isDamp;
    }

    public final float getFogDistanceMultiplier() {
        return this.fogDistanceMultiplier;
    }

    public abstract float @NotNull [] modifyFogColor(float var1, float var2, float var3, float var4);

    public void doEnvironmentUpdate(@NotNull World world, @NotNull Random rand, int x, int z) {
        if (world.getSeasonManager().getCurrentSeason() != null && !world.getSeasonManager().getCurrentSeason().letWeatherCleanUpSnow) {
            return;
        }
        if (rand.nextInt(4) == 0) {
            int y = world.getHeightValue(x, z);
            int blockId = world.getBlockId(x, y, z);
            int blockIdBelow = world.getBlockId(x, y - 1, z);
            if (world.getBlockBiome(x, y, z).hasTag(BiomeTags.HAS_SURFACE_SNOW)) {
                int meta;
                if (blockId == Blocks.LAYER_SNOW.id() && (meta = world.getBlockMetadata(x, y, z)) != 0) {
                    world.setBlockMetadata(x, y, z, meta - 1);
                    world.markBlockNeedsUpdate(x, y, z);
                }
            } else if (blockId == Blocks.LAYER_SNOW.id()) {
                int meta = world.getBlockMetadata(x, y, z);
                if (meta != 0) {
                    world.setBlockMetadata(x, y, z, meta - 1);
                    world.markBlockNeedsUpdate(x, y, z);
                } else {
                    world.setBlockWithNotify(x, y, z, 0);
                }
            } else if (blockIdBelow == Blocks.ICE.id()) {
                world.setBlockWithNotify(x, y - 1, z, Blocks.FLUID_WATER_STILL.id());
            }
        }
    }

    public void doChunkLoadEffect(@NotNull World world, @NotNull Chunk chunk) {
        if (world.getSeasonManager().getCurrentSeason() != null && !world.getSeasonManager().getCurrentSeason().letWeatherCleanUpSnow) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeightValue(x, z);
                if (y == 0) continue;
                int blockId = chunk.getBlockID(x, y, z);
                int blockIdBelow = chunk.getBlockID(x, y - 1, z);
                if (world.getBlockBiome(chunk.pos.x * 16 + x, y, chunk.pos.z * 16 + z).hasTag(BiomeTags.HAS_SURFACE_SNOW)) {
                    if (blockId != Blocks.LAYER_SNOW.id()) continue;
                    chunk.setBlockMetadata(x, y, z, 0);
                    continue;
                }
                if (blockId == Blocks.LAYER_SNOW.id()) {
                    chunk.setBlockID(x, y, z, 0);
                    continue;
                }
                if (blockIdBelow != Blocks.ICE.id()) continue;
                chunk.setBlockID(x, y - 1, z, Blocks.FLUID_WATER_STILL.id());
            }
        }
    }
}

