/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLayer<T extends BlockLogic>
extends BlockModelGeneric<T> {
    public final StaticBlockModel[] models = new StaticBlockModel[7];
    @NotNull
    private final TilePos queryPos = new TilePos();

    public BlockModelGenericLayer(@NotNull Block<T> block, @NotNull String basekey) {
        super(block, BlockModelDispatcher.loadDataModel(basekey + "/0"));
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = BlockModelDispatcher.loadDataModel(basekey + "/" + i).asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return this.models[(data & 7) % this.models.length];
    }

    @Override
    public boolean cullSide(@NotNull WorldSource worldSource, @NotNull TilePosc blockPos, @Nullable Direction direction) {
        if (direction != null) {
            TilePos shifted = blockPos.add(direction, this.queryPos);
            if (worldSource.getBlockType(shifted) == this.block) {
                int dataOther = worldSource.getBlockData(shifted);
                int dataSelf = worldSource.getBlockData(blockPos);
                return dataSelf <= dataOther || worldSource.isBlockOpaqueCube(shifted);
            }
            return worldSource.isBlockOpaqueCube(shifted);
        }
        return false;
    }
}

