/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.generic.BlockModelGenericVeryRotatable;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericPistonHead<T extends BlockLogic>
extends BlockModelGenericVeryRotatable<T> {
    @NotNull
    public final StaticBlockModel sticky;
    @NotNull
    public final StaticBlockModel steel;
    @NotNull
    public final StaticBlockModel baseHalf;
    @NotNull
    public final StaticBlockModel stickyHalf;
    @NotNull
    public final StaticBlockModel steelHalf;

    public BlockModelGenericPistonHead(@NotNull Block<T> block, @NotNull BlockModelData piston, @NotNull BlockModelData sticky, @NotNull BlockModelData steel, @NotNull BlockModelData pistonHalf, @NotNull BlockModelData stickyHalf, @NotNull BlockModelData steelHalf) {
        super(block, piston);
        this.sticky = sticky.asModel();
        this.steel = steel.asModel();
        this.baseHalf = pistonHalf.asModel();
        this.stickyHalf = stickyHalf.asModel();
        this.steelHalf = steelHalf.asModel();
    }

    public void renderPistonHeadNoCulling(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, int meta, @NotNull TilePos tilePos, boolean flag) {
        StaticBlockModel model = switch (BlockLogicPistonHead.getPistonType(meta)) {
            case 1 -> {
                if (flag) {
                    yield this.sticky;
                }
                yield this.stickyHalf;
            }
            case 2 -> {
                if (flag) {
                    yield this.steel;
                }
                yield this.steelHalf;
            }
            default -> flag ? this.staticModel : this.baseHalf;
        };
        Direction dir = BlockLogicVeryRotatable.metaToDirection(worldSource.getBlockData(tilePos));
        switch (dir) {
            case UP: {
                model.renderAttached(this, tessellator, worldSource, tilePos, 1, 0, 0, 0.0, 0.0, 0.0, false, false, null);
                break;
            }
            case DOWN: {
                model.renderAttached(this, tessellator, worldSource, tilePos, -1, 0, 0, 0.0, 0.0, 0.0, false, false, null);
                break;
            }
            case NORTH: {
                model.renderAttached(this, tessellator, worldSource, tilePos, 0, 0, 0, 0.0, 0.0, 0.0, false, false, null);
                break;
            }
            case SOUTH: {
                model.renderAttached(this, tessellator, worldSource, tilePos, 0, 2, 0, 0.0, 0.0, 0.0, false, false, null);
                break;
            }
            case WEST: {
                model.renderAttached(this, tessellator, worldSource, tilePos, 0, 1, 0, 0.0, 0.0, 0.0, false, false, null);
                break;
            }
            case EAST: {
                model.renderAttached(this, tessellator, worldSource, tilePos, 0, 3, 0, 0.0, 0.0, 0.0, false, false, null);
            }
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return switch (BlockLogicPistonHead.getPistonType(data)) {
            case 1 -> this.sticky;
            case 2 -> this.steel;
            default -> this.staticModel;
        };
    }
}

