/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import org.jetbrains.annotations.NotNull;

public class DynamicTextureWaterFlow
extends DynamicTexture {
    private final Minecraft mc = Minecraft.getMinecraft();
    private float[] current;
    private float[] next;
    private float[] heat;
    private float[] heata;
    private int ticks = 0;

    public DynamicTextureWaterFlow(@NotNull IconCoordinate targetTexture) {
        super(targetTexture);
    }

    @Override
    public void postInit() {
        this.initTexture();
        this.current = new float[this.targetTexture.getArea()];
        this.next = new float[this.targetTexture.getArea()];
        this.heat = new float[this.targetTexture.getArea()];
        this.heata = new float[this.targetTexture.getArea()];
    }

    @Override
    public void update() {
        float pow;
        int y;
        int x;
        ++this.ticks;
        for (x = 0; x < this.targetTexture.width; ++x) {
            for (y = 0; y < this.targetTexture.height; ++y) {
                pow = 0.0f;
                for (int k = y - 2; k <= y; ++k) {
                    int xi = DynamicTextureWaterFlow.pmod(x, this.targetTexture.width);
                    int yi = DynamicTextureWaterFlow.pmod(k, this.targetTexture.height);
                    pow += this.current[xi + yi * this.targetTexture.width];
                }
                this.next[x + y * this.targetTexture.width] = pow / 3.2f + this.heat[x + y * this.targetTexture.width] * 0.8f;
            }
        }
        for (x = 0; x < this.targetTexture.width; ++x) {
            for (y = 0; y < this.targetTexture.height; ++y) {
                int n = x + y * this.targetTexture.width;
                this.heat[n] = this.heat[n] + this.heata[x + y * this.targetTexture.width] * 0.05f;
                if (this.heat[x + y * this.targetTexture.width] < 0.0f) {
                    this.heat[x + y * this.targetTexture.width] = 0.0f;
                }
                int n2 = x + y * this.targetTexture.width;
                this.heata[n2] = this.heata[n2] - 0.3f;
                if (!(Math.random() < 0.2)) continue;
                this.heata[x + y * this.targetTexture.width] = 0.5f;
            }
        }
        float[] tmp = this.next;
        this.next = this.current;
        this.current = tmp;
        for (int i = 0; i < this.targetTexture.getArea(); ++i) {
            pow = this.current[DynamicTextureWaterFlow.pmod(i - this.ticks * this.targetTexture.width, this.targetTexture.getArea())];
            pow = MathHelper.clamp(pow, 0.0f, 1.0f);
            float pp = pow * pow;
            int r = (int)(32.0f + pp * 32.0f);
            int g = (int)(50.0f + pp * 64.0f);
            int b = 255;
            int a = (int)(146.0f + pp * 50.0f);
            if (this.mc.currentWorld != null && this.mc.currentWorld.getWorldType().hasTag(WorldTypeTags.NETHER)) {
                a = (int)(225.0f + pp * 50.0f);
                if (!((Boolean)GameSettings.BIOME_WATER.value).booleanValue()) {
                    float br = 0.3f;
                    r = 76;
                    g = (int)((50.0f + pp * 64.0f) * 0.3f);
                    b = (int)((32.0f + pp * 32.0f) * 0.3f);
                }
            }
            r = MathHelper.clamp(r, 0, 255);
            g = MathHelper.clamp(g, 0, 255);
            b = MathHelper.clamp(b, 0, 255);
            a = MathHelper.clamp(a, 0, 255);
            if (((Boolean)GameSettings.BIOME_WATER.value).booleanValue() && (this.mc.currentWorld == null || !this.mc.currentWorld.getWorldType().hasTag(WorldTypeTags.RETRO))) {
                g = b = (r + g + b) / 3;
                r = b;
            }
            this.imageData[i * 4] = (byte)r;
            this.imageData[i * 4 + 1] = (byte)g;
            this.imageData[i * 4 + 2] = (byte)b;
            this.imageData[i * 4 + 3] = (byte)a;
        }
    }
}

