/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.provider;

import java.util.Arrays;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.FractalNoise3D;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.SimplexNoise;
import net.minecraft.core.world.type.WorldTypes;
import org.jetbrains.annotations.NotNull;

public final class BiomeProviderNether
extends BiomeProvider {
    public static final Biome[] BIOMES_ORDER = new Biome[]{Biomes.NETHER_OLD_WORLD, Biomes.NETHER_CRYSTAL_PLAINS, Biomes.NETHER_CRYSTAL_FOREST, Biomes.NETHER_SHELF, Biomes.NETHER_CRAG, Biomes.NETHER_SULFUR_POOLS, Biomes.NETHER_VOLCANIC_ISLANDS};
    private final FractalNoise2D<?> temperatureNoise;
    private final FractalNoise2D<?> fuzzinessNoise;
    private final FractalNoise2D<?> varietyMap;
    private double temperatureXScale = 0.015;
    private double temperatureZScale = 0.015;
    private double temperatureLacunarity = 0.3;
    private double temperatureFuzzPercentage = 0.02;
    private double varietyXScale = 0.25;
    private double varietyZScale = 0.25;
    private double varietyLacunarity = 0.3;
    private double varietyNoise = 0.0;
    private double fuzzinessXScale = 0.2;
    private double fuzzinessZScale = 0.2;
    private double fuzzinessLacunarity = 0.25;

    public BiomeProviderNether(@NotNull World world) {
        super(world);
        long seed = world.getRandomSeed();
        this.temperatureNoise = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed * 5345L, 4));
        this.fuzzinessNoise = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed * 35864L, 2));
        this.varietyMap = new FractalNoise2D((Noise2D[])SimplexNoise.genOctaves(seed, 4));
    }

    @Override
    public Biome[] getBiomes(Biome[] biomes, double[] temperatures, double[] humidities, double[] varieties, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomes == null || biomes.length < xSize * ySize * zSize) {
            biomes = new Biome[xSize * ySize * zSize];
        }
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        this.getTemperatures(temperatures, x, z, xSize, zSize);
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        this.getHumidities(humidities, x, z, xSize, zSize);
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        this.getVarieties(varieties, x, z, xSize, zSize);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double temperature = temperatures[dx * zSize + dz];
                double humidity = humidities[dx * zSize + dz];
                double variety = varieties[dx * zSize + dz];
                for (int dy = 0; dy < ySize; ++dy) {
                    double altitude = WorldTypes.NETHER_DEFAULT.getYPercentage(this.world, y + dy << 3);
                    biomes[dy * xSize * zSize + dz * xSize + dx] = this.lookupBiome(temperature, humidity, altitude, variety);
                }
            }
        }
        return biomes;
    }

    public double getTemperature(double x, double z) {
        double[] tnResult = this.temperatureNoise.setLacunarity(this.temperatureLacunarity).getRegion(null, x, z, 1, 1, this.temperatureXScale, this.temperatureZScale);
        double[] fnResult = this.fuzzinessNoise.setLacunarity(this.fuzzinessLacunarity).getRegion(null, x, z, 1, 1, this.fuzzinessXScale, this.fuzzinessZScale);
        double fuzziness = fnResult[0] * 1.1 + 0.5;
        double fuzzPctg = this.temperatureFuzzPercentage;
        double valPctg = 1.0 - fuzzPctg;
        double temperature = tnResult[0] * valPctg + fuzziness * fuzzPctg;
        if ((temperature = 1.0 - (1.0 - temperature) * (1.0 - temperature)) < 0.0) {
            temperature = -temperature;
        }
        if (temperature > 1.0) {
            temperature = -temperature;
        }
        return temperature;
    }

    @Override
    public double[] getTemperatures(double[] temperatures, int x, int z, int xSize, int zSize) {
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        double[] tnResult = this.temperatureNoise.setLacunarity(this.temperatureLacunarity).getRegion(null, x, z, xSize, zSize, this.temperatureXScale, this.temperatureZScale);
        double[] fnResult = this.fuzzinessNoise.setLacunarity(this.fuzzinessLacunarity).getRegion(null, x, z, xSize, zSize, this.fuzzinessXScale, this.fuzzinessZScale);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double fuzziness = fnResult[dx * zSize + dz] * 1.1 + 0.5;
                double fuzzPctg = this.temperatureFuzzPercentage;
                double valPctg = 1.0 - fuzzPctg;
                double temperature = (tnResult[dx * zSize + dz] * 0.1 + 0.5) * valPctg + fuzziness * fuzzPctg;
                if ((temperature *= temperature) < 0.0) {
                    temperature = 0.0;
                }
                if (temperature > 1.0) {
                    temperature = 1.0;
                }
                temperatures[dx * zSize + dz] = temperature;
            }
        }
        return temperatures;
    }

    @Override
    public double[] getHumidities(double[] humidities, int x, int z, int xSize, int zSize) {
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        return humidities;
    }

    @Override
    public double[] getVarieties(double[] varieties, int x, int z, int xSize, int zSize) {
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        double[] vnResult = this.varietyMap.setLacunarity(this.varietyLacunarity).getRegion(null, x, z, xSize, zSize, this.varietyXScale, this.varietyZScale);
        double[] fnResult = this.fuzzinessNoise.setLacunarity(this.fuzzinessLacunarity).getRegion(null, x, z, xSize, zSize, this.fuzzinessXScale, this.fuzzinessZScale);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double fuzzPctg = this.varietyNoise;
                double valPctg = 1.0 - fuzzPctg;
                double fuzziness = fnResult[dx * zSize + dz] * 1.1 + 0.5;
                double variety = (vnResult[dx * zSize + dz] * 0.15 + 0.5) * valPctg + fuzziness * fuzzPctg;
                if (variety < 0.0) {
                    variety = 0.0;
                }
                if (variety > 1.0) {
                    variety = 1.0;
                }
                varieties[dx * zSize + dz] = variety;
            }
        }
        return varieties;
    }

    @Override
    public double[] getBiomenesses(double[] biomenesses, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomenesses == null || biomenesses.length < xSize * ySize * zSize) {
            biomenesses = new double[xSize * ySize * zSize];
        }
        Arrays.fill(biomenesses, 1.0);
        return biomenesses;
    }

    @Override
    public Biome lookupBiome(double temperature, double humidity, double altitude, double variety) {
        if (temperature <= 0.1) {
            if (variety >= 0.3 && variety <= 0.6) {
                return Biomes.NETHER_OLD_WORLD_DESERT;
            }
            return Biomes.NETHER_OLD_WORLD;
        }
        if (temperature <= 0.15) {
            return Biomes.NETHER_CRYSTAL_PLAINS;
        }
        if (temperature <= 0.3) {
            if (variety <= 0.3) {
                return Biomes.NETHER_CRYSTAL_PLAINS;
            }
            return Biomes.NETHER_CRYSTAL_FOREST;
        }
        if (temperature <= 0.35) {
            return Biomes.NETHER_SHELF;
        }
        if (temperature <= 0.65) {
            return Biomes.NETHER_CRAG;
        }
        if (variety <= 0.5) {
            return Biomes.NETHER_VOLCANIC_ISLANDS;
        }
        return Biomes.NETHER_SULFUR_POOLS;
    }

    public static Biome[] allBiomes() {
        return BIOMES_ORDER;
    }
}

