/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsCategory
implements OptionsComponent {
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static final ItemElement renderItem = new ItemElement(mc);
    private static final int PADDING = 2;
    private static final int TOP_SPACING = 24;
    private static final int COMPONENT_LEFT_MARGIN = 16;
    private final String translationKey;
    private final List<OptionsComponent> components = new ArrayList<OptionsComponent>();
    private OptionsComponent clickedComponent = null;
    private int clickedComponentY = 0;
    private boolean collapsed = false;
    private ItemStack icon = null;
    @Nullable
    private final String tooltipTranslationKey;
    @Nullable
    private String shownTooltipTranslationKey = null;

    public OptionsCategory(String translationKey) {
        this(translationKey, null);
    }

    public OptionsCategory(String translationKey, ItemStack icon) {
        this(translationKey, icon, null);
    }

    public OptionsCategory(String translationKey, ItemStack icon, @Nullable String tooltipTranslationKey) {
        this.translationKey = translationKey;
        this.tooltipTranslationKey = tooltipTranslationKey;
        this.icon = icon;
    }

    public OptionsCategory withComponent(OptionsComponent component) {
        if (component != null) {
            this.components.add(component);
        }
        return this;
    }

    @Override
    public void init(Minecraft mc) {
        for (OptionsComponent component : this.components) {
            component.init(mc);
        }
    }

    @Override
    @Nullable
    public String getTooltipTranslationKey() {
        return this.shownTooltipTranslationKey;
    }

    @Override
    public void tick() {
        for (OptionsComponent component : this.components) {
            component.tick();
        }
    }

    @Override
    public int getHeight() {
        int height = 24;
        if (!this.collapsed) {
            for (OptionsComponent component : this.components) {
                height += component.getHeight();
            }
        }
        return height;
    }

    @Override
    public void render(@NotNull ScreenOptions screenOptions, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        I18n i18n = I18n.getInstance();
        int textColor = 0x7F7F7F;
        this.shownTooltipTranslationKey = null;
        if (relativeMouseX >= 0 && relativeMouseX < width && relativeMouseY >= 0 && relativeMouseY < 24) {
            textColor = 0xFFFFA0;
            this.shownTooltipTranslationKey = this.tooltipTranslationKey;
        }
        OptionsCategory.mc.font.render(this.collapsed ? "\u25b7" : "\u25bd", x, y + 2 + 10).setShadow().setColor(textColor).call();
        int xOffset = 10;
        if (this.icon != null) {
            renderItem.render(this.icon, x + 11, y + 2 + 5);
            xOffset += 20;
        }
        OptionsCategory.mc.font.render(i18n.translateKey(this.translationKey), x + xOffset, y + 2 + 10).setShadow().setColor(textColor).call();
        if (!this.collapsed) {
            int componentY = 24;
            for (OptionsComponent component : this.components) {
                if (y + componentY + component.getHeight() >= screenOptions.top && y + componentY <= screenOptions.bottom) {
                    component.render(screenOptions, x + 16, y + componentY, width - 16, relativeMouseX - 16, relativeMouseY - componentY);
                }
                componentY += component.getHeight();
                @Nullable String componentTooltipTranslationKey = component.getTooltipTranslationKey();
                if (componentTooltipTranslationKey == null) continue;
                this.shownTooltipTranslationKey = componentTooltipTranslationKey;
            }
        }
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (relativeMouseX >= 0 && relativeMouseX < width && relativeMouseY >= 0 && relativeMouseY < 24) {
            this.collapsed = !this.collapsed;
            OptionsCategory.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        int componentY = 24;
        for (OptionsComponent component : this.components) {
            if (relativeMouseX >= 16 && relativeMouseX < width && relativeMouseY >= componentY && relativeMouseY < componentY + component.getHeight()) {
                component.onMouseClick(mouseButton, x + 16, componentY, width - 16, relativeMouseX - 16, relativeMouseY - componentY);
                this.clickedComponent = component;
                this.clickedComponentY = componentY;
                return;
            }
            componentY += component.getHeight();
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            this.clickedComponent.onMouseMove(x + 16, this.clickedComponentY, width - 16, relativeMouseX - 16, relativeMouseY - this.clickedComponentY);
        }
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.clickedComponent != null) {
            this.clickedComponent.onMouseRelease(mouseButton, x + 16, this.clickedComponentY, width - 16, relativeMouseX - 16, relativeMouseY - this.clickedComponentY);
        }
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
        for (OptionsComponent component : this.components) {
            component.onKeyPress(keyCode, character);
        }
    }

    public OptionsCategory filter(String term) {
        OptionsCategory category = new OptionsCategory(this.translationKey);
        for (OptionsComponent component : this.components) {
            if (!component.matchesSearchTerm(term)) continue;
            category.withComponent(component);
        }
        if (category.components.isEmpty()) {
            return null;
        }
        return category;
    }

    @Override
    public void onClose() {
        for (OptionsComponent component : this.components) {
            component.onClose();
        }
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }
}

