/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkSection;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.chunk.ChunkFeatureDecorator;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkGenerator {
    @NotNull
    protected final World world;
    @NotNull
    private final ChunkDecorator decorator;

    public ChunkGenerator(@NotNull World world, @NotNull ChunkDecorator decorator) {
        this.world = world;
        this.decorator = decorator;
    }

    @NotNull
    public final Chunk generate(int chunkX, int chunkZ) {
        Chunk chunk = new Chunk(this.world, chunkX, chunkZ);
        chunk.temperature = this.world.getBiomeProvider().getTemperatures(null, chunkX * 16, chunkZ * 16, 16, 16);
        chunk.humidity = this.world.getBiomeProvider().getHumidities(null, chunkX * 16, chunkZ * 16, 16, 16);
        chunk.variety = this.world.getBiomeProvider().getVarieties(null, chunkX * 16, chunkZ * 16, 16, 16);
        Biome[] biomes = new Biome[512];
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            this.world.getBiomeProvider().getBiomes(biomes, chunk.temperature, chunk.humidity, chunk.variety, chunkX * 16, sectionY * 16, chunkZ * 16, 16, 2, 16);
            ChunkSection section = chunk.getSection(sectionY);
            for (int i = 0; i < biomes.length; ++i) {
                section.biome[i] = (byte)Registries.BIOMES.getNumericIdOfItem(biomes[i]);
            }
        }
        ChunkGeneratorResult result = this.doBlockGeneration(chunk);
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            ChunkSection section = chunk.getSection(sectionY);
            section.blocks = result.getSectionBlocks(sectionY);
        }
        chunk.recalcHeightmapAndLightmap();
        return chunk;
    }

    public final void decorate(@NotNull Chunk chunk) {
        ChunkDecorator chunkDecorator = this.decorator;
        if (chunkDecorator instanceof ChunkFeatureDecorator) {
            ChunkFeatureDecorator featureDecorator = (ChunkFeatureDecorator)chunkDecorator;
            featureDecorator.registerDecorationsSetup();
        }
        this.decorator.decorate(chunk);
    }

    @NotNull
    protected abstract ChunkGeneratorResult doBlockGeneration(@NotNull Chunk var1);
}

