/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.structure;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class EditableStructure
implements Structure {
    @NotNull
    private final Structure parent;
    @NotNull
    private final Vector3i origin;
    private final int[] blocks;
    private final int[] data;

    public EditableStructure(@NotNull Structure parent) {
        this.parent = parent;
        this.origin = new Vector3i(parent.getOrigin());
        @NotNull Vector3ic size = parent.getSize();
        this.blocks = new int[size.x() * size.y() * size.z()];
        this.data = new int[size.x() * size.y() * size.z()];
        @NotNull Vector3i temp = new Vector3i();
        for (int x = 0; x < size.x(); ++x) {
            for (int y = 0; y < size.y(); ++y) {
                for (int z = 0; z < size.z(); ++z) {
                    temp.set(x, y, z);
                    this.blocks[this.toIndex((Vector3ic)temp)] = parent.getBlockType(temp).id();
                    this.data[this.toIndex((Vector3ic)temp)] = parent.getBlockData(temp);
                }
            }
        }
    }

    @Override
    @NotNull
    public Vector3ic getSize() {
        return this.parent.getSize();
    }

    @Override
    @NotNull
    public Vector3ic getOrigin() {
        return this.origin;
    }

    public void setOrigin(@NotNull Vector3ic origin) {
        this.origin.set(origin);
    }

    private int toIndex(@NotNull Vector3ic pos) {
        @NotNull Vector3ic size = this.getSize();
        return pos.y() * size.z() * size.x() + pos.z() * size.x() + pos.x();
    }

    @Override
    @NotNull
    public Block<?> getBlockType(@NotNull Vector3ic pos) {
        @NotNull Vector3ic size = this.getSize();
        if (pos.x() < 0 || pos.y() < 0 || pos.z() < 0 || pos.x() >= size.x() || pos.y() >= size.y() || pos.z() >= size.z()) {
            return Blocks.AIR;
        }
        return Blocks.getBlock(this.blocks[this.toIndex(pos)]);
    }

    @Override
    public int getBlockData(@NotNull Vector3ic pos) {
        @NotNull Vector3ic size = this.getSize();
        if (pos.x() < 0 || pos.y() < 0 || pos.z() < 0 || pos.x() >= size.x() || pos.y() >= size.y() || pos.z() >= size.z()) {
            return 0;
        }
        return this.data[this.toIndex(pos)];
    }

    public void setBlockType(@NotNull Vector3ic pos, @NotNull Block<?> block) {
        this.setBlockTypeData(pos, block, 0);
    }

    public void setBlockData(@NotNull Vector3ic pos, int data) {
        @NotNull Vector3ic size = this.getSize();
        if (pos.x() < 0 || pos.y() < 0 || pos.z() < 0 || pos.x() >= size.x() || pos.y() >= size.y() || pos.z() >= size.z()) {
            return;
        }
        this.data[this.toIndex((Vector3ic)pos)] = data;
    }

    public void setBlockTypeData(@NotNull Vector3ic pos, @NotNull Block<?> block, int data) {
        @NotNull Vector3ic size = this.getSize();
        if (pos.x() < 0 || pos.y() < 0 || pos.z() < 0 || pos.x() >= size.x() || pos.y() >= size.y() || pos.z() >= size.z()) {
            return;
        }
        this.blocks[this.toIndex((Vector3ic)pos)] = block.id();
        this.data[this.toIndex((Vector3ic)pos)] = data;
    }

    public void place(@NotNull World world, @NotNull TilePosc pos) {
        @NotNull Vector3ic size = this.getSize();
        @NotNull Vector3ic origin = this.getOrigin();
        @NotNull TilePos relativePos = new TilePos(pos.x() - origin.x(), pos.y() - origin.y(), pos.z() - origin.z());
        @NotNull TilePos tempTilePos = new TilePos();
        @NotNull Vector3i tempVector = new Vector3i();
        for (int dx = 0; dx < size.x(); ++dx) {
            for (int dy = 0; dy < size.y(); ++dy) {
                for (int dz = 0; dz < size.z(); ++dz) {
                    @NotNull Block<?> block = this.getBlockType(tempVector.set(dx, dy, dz));
                    int data = this.getBlockData(tempVector);
                    if (block.hasTag(BlockTags.PLACE_OVERWRITES)) continue;
                    world.setBlockTypeData(tempTilePos.set(relativePos).add(tempVector), block, data);
                }
            }
        }
    }
}

