/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldTypeFXNether
extends WorldTypeFX {
    public WorldTypeFXNether(WorldType worldType) {
        super(worldType);
    }

    @Override
    @NotNull
    public Vector3fc getFogColor(@NotNull World world, double x, double y, double z, float celestialAngle, float partialTick) {
        if (Colorizers.fog.isEnabled()) {
            int color = Colorizers.fog.getColor(world, new TilePos(x, y, z));
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new Vector3f(r, g, b);
        }
        float r = 0.23529412f;
        float g = 0.0f;
        float b = 0.0f;
        double temp = world.getBiomeProvider().getTemperature(MathHelper.floor(x), MathHelper.floor(z));
        if (temp < 0.25) {
            r = 0.0f;
            g = 0.0f;
            b = 0.0f;
        } else if (temp < 0.5) {
            double toLerp = temp - 0.25;
            r = MathHelper.lerp(0.0f, r, (float)(toLerp *= 4.0));
            g = MathHelper.lerp(0.0f, g, (float)toLerp);
            b = MathHelper.lerp(0.0f, b, (float)toLerp);
        }
        return new Vector3f(r, g, b);
    }

    @Override
    public void playerAnimationTick(@NotNull World world, @NotNull Player player) {
        double rz;
        double ry;
        double rx;
        int i;
        int radius;
        TilePos tilePos = new TilePos(player);
        Biome localBiome = world.getBlockBiome(tilePos);
        if (localBiome == Biomes.NETHER_OLD_WORLD) {
            radius = 12;
            for (i = 0; i < 3; ++i) {
                rx = player.x - 12.0 + world.rand.nextDouble() * 12.0 * 2.0;
                ry = player.y - 12.0 + world.rand.nextDouble() * 12.0 * 2.0;
                rz = player.z - 12.0 + world.rand.nextDouble() * 12.0 * 2.0;
                if (world.getBlockType(tilePos.set(MathHelper.floor(rx), MathHelper.floor(ry), MathHelper.floor(rz))) != Blocks.AIR) continue;
                world.spawnParticle("ashmote", rx, ry, rz, 0.0, 0.0, 0.0, 0);
            }
        }
        if (localBiome == Biomes.NETHER_VOLCANIC_ISLANDS) {
            radius = 24;
            for (i = 0; i < 2; ++i) {
                rx = player.x - 24.0 + world.rand.nextDouble() * 24.0 * 2.0;
                ry = player.y - 24.0 + world.rand.nextDouble() * 24.0 * 2.0;
                rz = player.z - 24.0 + world.rand.nextDouble() * 24.0 * 2.0;
                if (world.getBlockType(tilePos.set(MathHelper.floor(rx), MathHelper.floor(ry), MathHelper.floor(rz))) != Blocks.AIR) continue;
                world.spawnParticle("flame", rx, ry, rz, 0.0, 0.0, 0.0, 0);
            }
        }
    }
}

