/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicDoor
extends BlockLogic
implements IPaintable {
    public static final int MASK_ROTATION = 3;
    public static final int MASK_OPENED = 4;
    public static final int MASK_HINGE = 8;
    public final boolean isTop;
    public final boolean requireTool;
    @Nullable
    public final Supplier<Item> droppedItem;

    public BlockLogicDoor(@NotNull Block<?> block, @NotNull Material material, boolean isTop, boolean requireTool, @Nullable Supplier<@NotNull Item> droppedItem) {
        super(block, material);
        this.isTop = isTop;
        this.requireTool = requireTool;
        this.droppedItem = droppedItem;
        float halfWidth = 0.5f;
        if (isTop) {
            this.setBlockBounds(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = world.getBlockData(tilePos);
        if (world.hasNeighborSignal(tilePos)) {
            world.setBlockDataNotify(tilePos, meta | 4);
            if (this.isTop) {
                world.setBlockDataNotify(tilePos.down(new TilePos()), meta | 4);
            } else {
                world.setBlockDataNotify(tilePos.up(new TilePos()), meta | 4);
            }
            world.playBlockEvent(tilePos, 1003, 0);
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side.isVertical()) {
            return PartialSupport.INSTANCE;
        }
        int data = world.getBlockData(tilePos);
        int rot = this.getRotation(data);
        return switch (rot) {
            case 0 -> {
                if (side == Side.NORTH) {
                    yield FullSupport.INSTANCE;
                }
                yield PartialSupport.INSTANCE;
            }
            case 1 -> {
                if (side == Side.EAST) {
                    yield FullSupport.INSTANCE;
                }
                yield PartialSupport.INSTANCE;
            }
            case 2 -> {
                if (side == Side.SOUTH) {
                    yield FullSupport.INSTANCE;
                }
                yield PartialSupport.INSTANCE;
            }
            case 3 -> {
                if (side == Side.WEST) {
                    yield FullSupport.INSTANCE;
                }
                yield PartialSupport.INSTANCE;
            }
            default -> PartialSupport.INSTANCE;
        };
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return this.getBoundsForRotation(this.getRotation(source.getBlockData(tilePos)), false);
    }

    @NotNull
    public AABBdc getBoundsForRotation(int rotation, boolean drawingSelection) {
        float bottom;
        float top;
        if (this.isTop && drawingSelection) {
            top = 1.0f;
            bottom = -1.0f;
        } else if (drawingSelection) {
            top = 2.0f;
            bottom = 0.0f;
        } else {
            top = 1.0f;
            bottom = 0.0f;
        }
        float f = 0.1875f;
        return switch (rotation) {
            case 0 -> new AABBd(0.0, bottom, 0.0, 1.0, top, 0.1875);
            case 1 -> new AABBd(0.8125, bottom, 0.0, 1.0, top, 1.0);
            case 2 -> new AABBd(0.0, bottom, 0.8125, 1.0, top, 1.0);
            case 3 -> new AABBd(0.0, bottom, 0.0, 0.1875, top, 1.0);
            default -> new AABBd(0.0, bottom, 0.0, 1.0, top, 1.0);
        };
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onInteracted(world, tilePos, player, side, xHit, yHit);
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @Nullable Player player, @Nullable Side side, double xHit, double yHit) {
        if (this.material == Materials.METAL || this.material == Materials.STEEL) {
            return false;
        }
        TilePos queryPos = new TilePos();
        int data = world.getBlockData(tilePos);
        if (this.isTop) {
            Block<?> b = world.getBlockType(tilePos.down(queryPos));
            Object obj = b.getLogic();
            if (obj instanceof BlockLogicDoor) {
                BlockLogicDoor blockLogicDoor = (BlockLogicDoor)obj;
                blockLogicDoor.onInteracted(world, tilePos.down(queryPos), player, side, xHit, yHit);
            }
            return true;
        }
        @Nullable Block<?> b = world.getBlockType(tilePos.up(queryPos));
        if (b.getLogic() instanceof BlockLogicDoor) {
            world.setBlockDataNotify(tilePos.up(queryPos), data ^ 4);
        }
        int openedData = data ^ 4;
        world.setBlockDataNotify(tilePos, openedData);
        if (!this.isSupported(world, tilePos, openedData)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, openedData, null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
            if (world.getBlockLogic(tilePos.up(queryPos), BlockLogicDoor.class) != null) {
                world.setBlockTypeNotify(tilePos.up(queryPos), Blocks.AIR);
            }
        }
        world.markBlocksDirty(tilePos.down(queryPos), tilePos);
        world.playBlockEvent(player, tilePos, 1003, 0);
        return true;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        this.onInteracted(world, tilePos, null, direction.getSide(), 0.5, 0.5);
    }

    public void onPoweredBlockChange(@NotNull World world, @NotNull TilePosc tilePos, boolean isPowered) {
        boolean isOpen;
        int data = world.getBlockData(tilePos);
        if ((data & 8) > 0) {
            isPowered = !isPowered;
        }
        TilePos queryPos = new TilePos();
        if (this.isTop) {
            @Nullable Block<?> b = world.getBlockType(tilePos.down(queryPos));
            if (b.getLogic() instanceof BlockLogicDoor) {
                ((BlockLogicDoor)b.getLogic()).onPoweredBlockChange(world, tilePos.down(queryPos), isPowered);
            }
            return;
        }
        boolean bl = isOpen = (world.getBlockData(tilePos) & 4) != 0;
        if (isOpen == isPowered) {
            return;
        }
        @Nullable Block<?> b = world.getBlockType(tilePos.up(queryPos));
        if (b.getLogic() instanceof BlockLogicDoor) {
            world.setBlockDataNotify(tilePos.up(queryPos), data ^ 4);
        }
        world.setBlockDataNotify(tilePos, data ^ 4);
        world.markBlocksDirty(tilePos.down(queryPos), tilePos);
        world.playBlockEvent(tilePos, 1003, 0);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        int data = world.getBlockData(tilePos);
        TilePos queryPos = new TilePos();
        if (this.isTop) {
            @NotNull Block<?> b = world.getBlockType(tilePos.down(queryPos));
            if (!(b.getLogic() instanceof BlockLogicDoor)) {
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
            }
            if (block.isSignalSource()) {
                b.onNeighborChanged(world, tilePos.down(queryPos), block);
            }
        } else {
            boolean hasCommittedSuicide = false;
            @NotNull Block<?> otherBlock = world.getBlockType(tilePos.up(queryPos));
            if (!(otherBlock.getLogic() instanceof BlockLogicDoor)) {
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
                hasCommittedSuicide = true;
            }
            if (!this.isSupported(world, tilePos, data)) {
                this.dropWithCause(world, EnumDropCause.WORLD, tilePos, data, null, null);
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
                hasCommittedSuicide = true;
                if (otherBlock.getLogic() instanceof BlockLogicDoor) {
                    world.setBlockTypeNotify(tilePos.up(queryPos), Blocks.AIR);
                }
            }
            if (!hasCommittedSuicide && block.isSignalSource()) {
                boolean hasSignal = world.hasNeighborSignal(tilePos) || world.hasNeighborSignal(tilePos.up(queryPos));
                this.onPoweredBlockChange(world, tilePos, hasSignal);
            }
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        TilePos queryPos = new TilePos();
        if (this.isTop) {
            if (world.getBlockLogic(tilePos.down(queryPos), BlockLogicDoor.class) != null) {
                world.setBlockTypeNotify(tilePos.down(queryPos), Blocks.AIR);
            }
        } else if (world.getBlockLogic(tilePos.up(queryPos), BlockLogicDoor.class) != null) {
            world.setBlockTypeNotify(tilePos.up(queryPos), Blocks.AIR);
        }
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (this.droppedItem == null) {
            return null;
        }
        if (this.requireTool && dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this.droppedItem.get())};
        }
        if (!this.requireTool) {
            return new ItemStack[]{new ItemStack(this.droppedItem.get())};
        }
        return null;
    }

    public int getRotation(int i) {
        if ((i & 4) != 0) {
            return i & 3;
        }
        return i - 1 & 3;
    }

    public static boolean isOpen(int i) {
        boolean hasRightHinge = (i & 8) != 0;
        boolean opened = (i & 4) != 0;
        return !hasRightHinge && opened || hasRightHinge && !opened;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        if (tilePos.y() >= world.getHeightBlocks() - 1) {
            return false;
        }
        return this.isSupported(world, tilePos, world.getBlockData(tilePos)) && super.canPlaceAt(world, tilePos.up(new TilePos()));
    }

    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        if (tilePos.y() >= world.getHeightBlocks() - 1) {
            return false;
        }
        return this.isSupported(world, tilePos, data) && super.canPlaceAt(world, tilePos.up(new TilePos()));
    }

    public boolean isSupported(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        boolean hinge;
        if (this.isTop) {
            return true;
        }
        TilePos queryPos = new TilePos();
        @NotNull ISupport sBelow = world.getSupport(tilePos.down(queryPos), Side.TOP);
        boolean opened = (data & 4) != 0;
        boolean bl = hinge = (data & 8) != 0;
        if (opened) {
            if (hinge) {
                switch (this.getRotation(data)) {
                    case 0: {
                        @NotNull Side side = Side.WEST;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                    }
                    case 1: {
                        @NotNull Side side = Side.NORTH;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                    }
                    case 2: {
                        @NotNull Side side = Side.EAST;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                    }
                    case 3: {
                        @NotNull Side side = Side.SOUTH;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                    }
                }
            } else {
                switch (this.getRotation(data)) {
                    case 0: {
                        @NotNull Side side = Side.NORTH;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                    }
                    case 1: {
                        @NotNull Side side = Side.EAST;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                    }
                    case 2: {
                        @NotNull Side side = Side.SOUTH;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                    }
                    case 3: {
                        @NotNull Side side = Side.WEST;
                        @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                        return sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                    }
                }
            }
        } else if (hinge) {
            switch (this.getRotation(data)) {
                case 0: {
                    @NotNull Side side = Side.NORTH;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                }
                case 1: {
                    @NotNull Side side = Side.EAST;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                }
                case 2: {
                    @NotNull Side side = Side.SOUTH;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                }
                case 3: {
                    @NotNull Side side = Side.WEST;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.right(), side);
                }
            }
        } else {
            switch (this.getRotation(data)) {
                case 0: {
                    @NotNull Side side = Side.EAST;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                }
                case 1: {
                    @NotNull Side side = Side.SOUTH;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.up(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                }
                case 2: {
                    @NotNull Side side = Side.WEST;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.right(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                }
                case 3: {
                    @NotNull Side side = Side.NORTH;
                    @NotNull ISupport hingeSupport = world.getSupport(tilePos.add(side.getDirection(), queryPos), side.getOpposite());
                    return sBelow.canSupport(PartialSupport.INSTANCE.left(), Side.BOTTOM) || sBelow.canSupport(PartialSupport.INSTANCE.down(), Side.BOTTOM) || hingeSupport.canSupport(PartialSupport.INSTANCE.left(), side);
                }
            }
        }
        return false;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }

    @Override
    public boolean canBePainted() {
        return this.material == Materials.WOOD;
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        TilePos queryPos = new TilePos();
        int data = world.getBlockData(tilePos);
        if (this.isTop) {
            world.setBlockTypeDataRaw(tilePos, Blocks.DOOR_PLANKS_PAINTED_TOP, data);
            Blocks.DOOR_PLANKS_PAINTED_TOP.getLogic().setColor(world, tilePos, color);
            world.setBlockTypeDataRaw(tilePos.down(queryPos), Blocks.DOOR_PLANKS_PAINTED_BOTTOM, data);
            Blocks.DOOR_PLANKS_PAINTED_BOTTOM.getLogic().setColor(world, tilePos.down(queryPos), color);
        } else {
            world.setBlockTypeDataRaw(tilePos, Blocks.DOOR_PLANKS_PAINTED_BOTTOM, data);
            Blocks.DOOR_PLANKS_PAINTED_BOTTOM.getLogic().setColor(world, tilePos, color);
            world.setBlockTypeDataRaw(tilePos.up(queryPos), Blocks.DOOR_PLANKS_PAINTED_TOP, data);
            Blocks.DOOR_PLANKS_PAINTED_TOP.getLogic().setColor(world, tilePos.up(queryPos), color);
        }
    }
}

