/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class BlockLogicRubyglassCrop
extends BlockLogic {
    public static final int MASK_GROWTH_STAGE = 3;
    public static final int MAX_GROWTH_STATE = 3;

    public BlockLogicRubyglassCrop(Block<?> block) {
        super(block, Materials.PLANT);
        block.setTicking(true);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @Nullable
    public AABBd getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    public boolean mayPlaceOnBlockAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return world.getBlockType(tilePos) == Blocks.COBBLE_NETHERRACK || world.getBlockType(tilePos) == Blocks.COBBLE_NETHERRACK_CRYSTALLINE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull TilePos temp = new TilePos();
        return this.mayPlaceOnBlockAt(world, tilePos.down(temp));
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        @NotNull TilePos temp = new TilePos();
        return this.mayPlaceOnBlockAt(world, tilePos.down(temp));
    }

    public boolean isValidGrowthConditions(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos cursor = new TilePos(tilePos.x(), tilePos.y() + 1, tilePos.z());
        TilePos waterCursor = new TilePos(tilePos.x(), tilePos.y() + 2, tilePos.z());
        boolean isAir = world.isAirBlock(cursor);
        for (int iy = 1; iy < 8 && iy < world.getWorldType().getMaxY(world) - 1; ++iy) {
            cursor.set(cursor.x, ++cursor.y, cursor.z);
            waterCursor.set(waterCursor.x, ++waterCursor.y, waterCursor.z);
            boolean solidBlockFound = world.isBlockNormalCube(cursor);
            if (isAir) {
                if (solidBlockFound) {
                    return world.getBlockType(waterCursor).hasTag(BlockTags.IS_WATER);
                }
            } else {
                return false;
            }
            isAir = world.isAirBlock(cursor);
        }
        return false;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (!this.canStay(world, tilePos)) {
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        super.updateTick(world, tilePos, rand, isRandomTick);
        if (this.isValidGrowthConditions(world, tilePos)) {
            float growthRate;
            int stage;
            TilePos blockBelow = new TilePos();
            tilePos.down(blockBelow);
            if (world.getBlockType(blockBelow) == Blocks.COBBLE_NETHERRACK) {
                world.setBlockTypeNotify(blockBelow, Blocks.COBBLE_NETHERRACK_CRYSTALLINE);
            }
            if ((stage = BlockLogicRubyglassCrop.metaToGrowthStage(world.getBlockData(tilePos))) < 3 && (growthRate = this.getGrowthRate(world, tilePos)) > 0.0f && rand.nextInt((int)(100.0f / growthRate)) == 0) {
                world.setBlockDataNotify(tilePos, stage + 1);
            }
        }
    }

    private float getGrowthRate(@NotNull World world, @NotNull TilePosc tilePos) {
        float growthRate = 0.0f;
        if (world.getWorldType().hasTag(WorldTypeTags.HOT)) {
            growthRate = 5.0f;
        } else if (this.isLavaNearby(world, tilePos)) {
            growthRate = 3.5f;
        }
        return growthRate;
    }

    public boolean isLavaNearby(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos cursor = new TilePos();
        TilePos queryPos = new TilePos();
        tilePos.down(cursor);
        return world.getBlockType(cursor.east(queryPos)).hasTag(BlockTags.IS_LAVA) || world.getBlockType(cursor.west(queryPos)).hasTag(BlockTags.IS_LAVA) || world.getBlockType(cursor.down(queryPos)).hasTag(BlockTags.IS_LAVA) || world.getBlockType(cursor.south(queryPos)).hasTag(BlockTags.IS_LAVA) || world.getBlockType(cursor.north(queryPos)).hasTag(BlockTags.IS_LAVA);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (data != 3) {
            return new ItemStack[]{new ItemStack(Items.RUBYGLASS_CRYSTAL_CRACKED)};
        }
        return new ItemStack[]{new ItemStack(Items.RUBYGLASS_CRYSTAL_PURE)};
    }

    public static int metaToGrowthStage(int meta) {
        return meta & 3;
    }
}

