/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.weatherable.operation;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.generate.feature.weatherable.Operation;
import net.minecraft.core.world.structure.EditableStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class MossOperation
implements Operation {
    private static final int MAX_ITERATIONS = 100;

    @Override
    public void apply(@NotNull EditableStructure structure, @NotNull Random random) {
        int z;
        int y;
        int x;
        int iterations = 0;
        Vector3ic size = structure.getSize();
        Vector3ic origin = structure.getOrigin();
        int sizeAbove = size.y() - origin.y();
        Vector3i queryPos = new Vector3i();
        do {
            x = random.nextInt(size.x());
            y = origin.y() + random.nextInt(random.nextInt(sizeAbove) + 1);
            z = random.nextInt(size.z());
            queryPos.set(x, y, z);
        } while (structure.getBlockType(queryPos) == Blocks.AIR && ++iterations < 100);
        if (iterations >= 100) {
            return;
        }
        @Nullable Block<?> toMoss = this.toMoss(structure.getBlockType(queryPos.set(x, y, z)));
        if (toMoss == null) {
            return;
        }
        structure.setBlockType(queryPos, toMoss);
    }

    @Nullable
    private Block<?> toMoss(@NotNull Block<?> block) {
        if (block == Blocks.STONE) {
            return Blocks.MOSS_STONE;
        }
        if (block == Blocks.COBBLE_STONE) {
            return Blocks.COBBLE_STONE_MOSSY;
        }
        if (block == Blocks.BRICK_STONE_POLISHED) {
            return Blocks.BRICK_STONE_POLISHED_MOSSY;
        }
        return null;
    }
}

