/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.gui.hud.component.layout.LayoutAbsolute;
import net.minecraft.client.gui.hud.component.layout.LayoutSnap;

public abstract class HudComponent {
    protected static final Minecraft mc = Minecraft.getMinecraft();
    private final String key;
    private final int xSize;
    private final int ySize;
    Layout layout;

    public HudComponent(String key, int xSize, int ySize, Layout layout) {
        this.key = key;
        this.xSize = xSize;
        this.ySize = ySize;
        this.layout = layout;
    }

    public abstract boolean isVisible();

    public boolean isEnabled() {
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public int getXSize() {
        if (!this.isEnabled() || !(HudComponent.mc.currentScreen instanceof ScreenHudDesigner) && !this.isVisible()) {
            return 0;
        }
        return this.xSize;
    }

    public int getYSize() {
        if (!this.isEnabled() || !(HudComponent.mc.currentScreen instanceof ScreenHudDesigner) && !this.isVisible()) {
            return 0;
        }
        return this.ySize;
    }

    public int getAnchorX(ComponentAnchor anchor) {
        return (int)(anchor.xPosition * (float)this.getXSize());
    }

    public int getAnchorY(ComponentAnchor anchor) {
        return (int)(anchor.yPosition * (float)this.getYSize());
    }

    public Layout getLayout() {
        return this.layout;
    }

    public abstract void render(HudIngame var1, int var2, int var3, float var4);

    public abstract void renderPreview(Gui var1, Layout var2, int var3, int var4);

    public final String toSettingsString() {
        String layoutString;
        if (this.layout instanceof LayoutAbsolute) {
            layoutString = "abs";
        } else if (this.layout instanceof LayoutSnap) {
            layoutString = "snap";
        } else {
            throw new RuntimeException("Unknown layout type: " + this.layout.getClass().getName());
        }
        return this.key + "{[" + this.toSettingsParametersString() + "];" + layoutString + "[" + this.layout.toSettingsString() + "]}";
    }

    public final void fromSettingsString(String settings) {
        String[] parts = settings.split(";");
        String parameters = parts[0].substring(1, parts[0].length() - 1);
        this.fromSettingsParametersString(parameters);
        String layoutString = parts[1].substring(0, parts[1].indexOf(91));
        String layoutSettings = parts[1].substring(parts[1].indexOf(91) + 1, parts[1].length() - 1);
        if (layoutString.equals("abs")) {
            this.layout = new LayoutAbsolute(0.0f, 0.0f, ComponentAnchor.TOP_LEFT);
        } else if (layoutString.equals("snap")) {
            this.layout = new LayoutSnap(null, ComponentAnchor.TOP_LEFT, ComponentAnchor.TOP_LEFT);
        } else {
            throw new RuntimeException("Unknown layout type: " + layoutString);
        }
        this.layout.fromSettingsString(layoutSettings);
    }

    protected String toSettingsParametersString() {
        return "";
    }

    protected void fromSettingsParametersString(String settings) {
    }
}

