/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicTransparent;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicIce
extends BlockLogicTransparent {
    public BlockLogicIce(@NotNull Block<?> block) {
        super(block, Materials.ICE);
        block.friction = 0.98f;
        block.setTicking(true);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void onHarvest(@NotNull World world, @NotNull Player player, @NotNull TilePosc tilePos, int data, @Nullable TileEntity tileEntity) {
        super.onHarvest(world, player, tilePos, data, tileEntity);
        Material material = world.getBlockMaterial(tilePos.down(new TilePos()));
        ItemStack held = player.getHeldItem();
        if (!(!material.blocksMotion() && !material.isLiquid() || held != null && held.getItem().isSilkTouch())) {
            world.setBlockTypeNotify(tilePos, Blocks.FLUID_WATER_FLOWING);
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (isRandomTick && rand.nextInt(8) == 0 && world.getWorldType().hasTag(WorldTypeTags.HOT)) {
            world.setBlockTypeNotify(tilePos, Blocks.FLUID_WATER_STILL);
        }
        if (world.getSavedLightValue(LightLayer.Block, tilePos) > 11 - this.block.lightBlock()) {
            world.setBlockTypeNotify(tilePos, Blocks.FLUID_WATER_STILL);
        }
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 0;
    }
}

