/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeIntegerCoordinates;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.structure.EditableStructure;
import net.minecraft.core.world.structure.SavedStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class CommandStructure
implements CommandManager.CommandRegistry {
    @NotNull
    private static final SimpleCommandExceptionType SAVE_FAILURE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.structure.save.exception_failure"));
    @NotNull
    private static final SimpleCommandExceptionType LOAD_FAILURE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.structure.load.exception_failure"));

    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        @NotNull LiteralCommandNode<CommandSource> command = dispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("structure").requires(CommandSource::hasAdmin)).then(ArgumentBuilderLiteral.literal("save").then(ArgumentBuilderRequired.argument("id", ArgumentTypeString.string()).then(ArgumentBuilderRequired.argument("position", ArgumentTypeIntegerCoordinates.intCoordinates()).then(ArgumentBuilderRequired.argument("size", ArgumentTypeIntegerCoordinates.intCoordinates()).then(ArgumentBuilderRequired.argument("origin", ArgumentTypeIntegerCoordinates.intCoordinates()).executes(c -> {
            @NotNull CommandSource source = (CommandSource)c.getSource();
            @NotNull String id = c.getArgument("id", String.class);
            @NotNull IntegerCoordinates position = c.getArgument("position", IntegerCoordinates.class);
            @NotNull IntegerCoordinates size = c.getArgument("size", IntegerCoordinates.class);
            @NotNull IntegerCoordinates origin = c.getArgument("origin", IntegerCoordinates.class);
            if (!SavedStructure.save(source.getWorld(), id, new TilePos(position.getX(source), position.getY(source, true), position.getZ(source)), new Vector3i(size.getX(source), size.getY(source, false), size.getZ(source)), new Vector3i(origin.getX(source), origin.getY(source, false), origin.getZ(source)))) {
                throw SAVE_FAILURE.create();
            }
            source.sendTranslatableMessage("command.commands.structure.save.success", new Object[0]);
            return 1;
        }))))))).then(ArgumentBuilderLiteral.literal("load").then(ArgumentBuilderRequired.argument("id", ArgumentTypeString.string()).then(ArgumentBuilderRequired.argument("position", ArgumentTypeIntegerCoordinates.intCoordinates()).executes(c -> {
            @NotNull CommandSource source = (CommandSource)c.getSource();
            @NotNull String id = c.getArgument("id", String.class);
            @NotNull IntegerCoordinates position = c.getArgument("position", IntegerCoordinates.class);
            @Nullable SavedStructure structure = SavedStructure.load(id);
            if (structure == null) {
                throw LOAD_FAILURE.create();
            }
            @NotNull EditableStructure editableStructure = new EditableStructure(structure);
            editableStructure.place(source.getWorld(), new TilePos(position.getX(source), position.getY(source, true), position.getZ(source)));
            source.sendTranslatableMessage("command.commands.structure.load.success", new Object[0]);
            return 1;
        })))));
    }
}

