/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseFilter;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.ParticlesQuality;
import net.minecraft.client.render.FogManager;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.EntityCameraIsometric;
import net.minecraft.client.render.camera.EntityCameraSleeping;
import net.minecraft.client.render.camera.EntityCameraThirdPersonFront;
import net.minecraft.client.render.camera.EntityCameraThirdPersonRear;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.particle.ParticleSmoke;
import net.minecraft.client.render.particle.ParticleWaterDrop;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.debug.Debug;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class WorldRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final long nsPerSecond = 1000000000L;
    public final LightmapHelper lightmapHelper;
    public Minecraft mc;
    public float farPlaneDistance;
    public ItemRenderer itemRenderer;
    public FogManager fogManager;
    private int tick;
    private Entity pointedEntity;
    private final MouseFilter mouseFilterXAxis;
    private final MouseFilter mouseFilterYAxis;
    private final float fovModifier;
    private float fovModifierLast;
    private long systemTime;
    private final Random random;
    private int rainSoundCounter;
    public boolean zooming = false;
    private float zoomProgress;
    private float fovMod = 1.0f;
    private float fovModOld = 1.0f;

    public WorldRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.lightmapHelper = new LightmapHelper(minecraft, this);
        this.farPlaneDistance = 0.0f;
        this.pointedEntity = null;
        this.mouseFilterXAxis = new MouseFilter();
        this.mouseFilterYAxis = new MouseFilter();
        this.fovModifier = 0.0f;
        this.fovModifierLast = 0.0f;
        this.systemTime = 0L;
        this.random = new Random();
        this.rainSoundCounter = 0;
        this.itemRenderer = new ItemRenderer(minecraft);
        this.fogManager = new FogManager(this.mc);
    }

    public void updateRenderer() {
        this.updateSpeedFov();
        this.fovModifierLast = this.fovModifier;
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.mc.activeCamera.tick();
        this.fogManager.updateBrightness();
        ++this.tick;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
        this.lightmapHelper.tick();
    }

    private void updateSpeedFov() {
        PlayerLocal player = this.mc.thePlayer;
        float currentFovModifier = (Boolean)GameSettings.FOV_MODIFICATION.value != false ? player.getFovModifier() : 1.0f;
        this.fovModOld = this.fovMod;
        this.fovMod += (currentFovModifier - this.fovMod) * 0.5f;
    }

    public void getMouseOver(float partialTicks) {
        if (this.mc.activeCamera == null) {
            return;
        }
        if (this.mc.currentWorld == null) {
            return;
        }
        double blockReach = this.mc.thePlayer.getGamemode().getBlockReachDistance();
        double entityReach = this.mc.thePlayer.getGamemode().getEntityReachDistance();
        Vector3dc pos1 = this.mc.thePlayer.getPosition(partialTicks, true);
        Vector3dc look = this.mc.thePlayer.getViewVector(partialTicks);
        assert (look != null);
        Vector3d pos2 = pos1.add(look.x() * blockReach, look.y() * blockReach, look.z() * blockReach, new Vector3d());
        this.mc.objectMouseOver = this.mc.thePlayer.rayCast(blockReach, partialTicks, false, false, true);
        double hitBlockDistance = 1000.0;
        if (this.mc.objectMouseOver != null) {
            hitBlockDistance = pos1.distance(this.mc.objectMouseOver.location);
        }
        this.pointedEntity = null;
        float expand = 1.0f;
        AABBd entitySearchBox = MathHelper.aabbExpand(this.mc.thePlayer.bb, look.x() * entityReach, look.y() * entityReach, look.z() * entityReach, new AABBd());
        MathHelper.aabbGrow(entitySearchBox, expand, expand, expand, entitySearchBox);
        List<Entity> entities = this.mc.currentWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, entitySearchBox);
        double pointedEntityDistance = 0.0;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = entities.get(i);
            if (!entity.isSelectable()) continue;
            float hitRadius = entity == this.mc.thePlayer.vehicle ? 0.0f : entity.getPickRadius();
            AABBd hitBox = MathHelper.aabbGrow(entity.bb, hitRadius, hitRadius, hitRadius, new AABBd());
            if (hitBox.containsPoint(pos1)) {
                this.pointedEntity = entity;
                pointedEntityDistance = 0.0;
                continue;
            }
            HitResult.Clip hitResult = MathHelper.aabbClip(hitBox, pos1, pos2);
            if (hitResult == null) continue;
            double entityDistance = pos1.distance(hitResult.location);
            if (this.pointedEntity != null && !(entityDistance < pointedEntityDistance)) continue;
            this.pointedEntity = entity;
            pointedEntityDistance = entityDistance;
        }
        if (pointedEntityDistance > hitBlockDistance || pointedEntityDistance > entityReach) {
            this.pointedEntity = null;
        }
        if (this.pointedEntity != null) {
            this.mc.objectMouseOver = new HitResult.Entity(this.pointedEntity);
        }
    }

    private float getFOVModifier(float partialTick, boolean isModifiedByFOV) {
        Mob entityliving = null;
        ICamera iCamera = this.mc.activeCamera;
        if (iCamera instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)iCamera;
            entityliving = entityCamera.mob;
        }
        float fov = 70.0f;
        if (isModifiedByFOV) {
            fov = (int)(this.mc.activeCamera.getFov() * 100.0 + 30.0);
            fov *= org.joml.Math.lerp(this.fovModOld, this.fovMod, partialTick);
        }
        if (((Boolean)GameSettings.FOV_MODIFICATION.value).booleanValue() && CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTick)) {
            fov -= 10.0f;
        }
        if (entityliving != null && entityliving.getHealth() <= 0) {
            float f2 = (float)entityliving.deathTime + partialTick;
            fov /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return fov + this.fovModifierLast + (this.fovModifier - this.fovModifierLast) * partialTick;
    }

    @NotNull
    private Matrix4f hurtCameraEffect(@NotNull Matrix4f matrix, float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (!(iCamera instanceof EntityCamera)) {
            return matrix;
        }
        EntityCamera entityCamera = (EntityCamera)iCamera;
        Mob mob = entityCamera.mob;
        float hurtInterp = (float)mob.hurtTime - partialTick;
        if (mob.getHealth() <= 0) {
            float f2 = (float)mob.deathTime + partialTick;
            matrix.rotateZ(org.joml.Math.toRadians(40.0f - 8000.0f / (f2 + 200.0f)));
        }
        if (hurtInterp >= 0.0f) {
            hurtInterp /= (float)mob.maxHurtTime;
            hurtInterp = MathHelper.sin(hurtInterp * hurtInterp * hurtInterp * hurtInterp * (float)Math.PI);
            float f3 = mob.attackedAtYaw;
            matrix.rotateY(org.joml.Math.toRadians(-f3));
            matrix.rotateZ(org.joml.Math.toRadians(-hurtInterp * 14.0f));
            matrix.rotateY(org.joml.Math.toRadians(f3));
        }
        return matrix;
    }

    @NotNull
    private Matrix4f setupViewBobbing(@NotNull Matrix4f matrix, float partialTick, boolean isHand) {
        Object object = this.mc.activeCamera;
        if (object instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)object;
            object = entityCamera.mob;
            if (object instanceof Player) {
                Player player = (Player)object;
                float walkDist = -MathHelper.lerp(player.walkDistO, player.walkDist, partialTick);
                float cameraVel = MathHelper.lerp(player.cameraVelocityOld, player.cameraVelocity, partialTick);
                float cameraPitch = MathHelper.lerp(player.prevCameraPitch, player.cameraPitch, partialTick);
                if (isHand && player.vehicle instanceof MobPig) {
                    cameraVel /= 4.0f;
                    walkDist /= 2.0f;
                }
                if (player.isSkating) {
                    walkDist *= 0.25f;
                    cameraPitch *= 0.25f;
                }
                matrix.translate(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 0.5f, -Math.abs(MathHelper.cos(walkDist * (float)Math.PI) * cameraVel), 0.0f);
                matrix.rotateZ(org.joml.Math.toRadians(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 3.0f));
                matrix.rotateX(org.joml.Math.toRadians(org.joml.Math.abs(MathHelper.cos(walkDist * (float)Math.PI - 0.2f) * cameraVel) * 5.0f));
                matrix.rotateX(org.joml.Math.toRadians(cameraPitch));
            }
        }
        return matrix;
    }

    private void setupCamera(float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (iCamera instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)iCamera;
            Mob mob = entityCamera.mob;
            if (this.mc.currentScreen instanceof ScreenPhotoMode) {
                this.mc.activeCamera = new EntityCameraIsometric(this.mc, mob);
            } else if (mob.isPlayerSleeping()) {
                if (!(this.mc.activeCamera instanceof EntityCameraSleeping)) {
                    this.mc.activeCamera = new EntityCameraSleeping(this.mc, mob, MathHelper.floor(mob.x), MathHelper.floor(mob.y), MathHelper.floor(mob.z), this.mc.activeCamera.getX(partialTick), this.mc.activeCamera.getY(partialTick), this.mc.activeCamera.getZ(partialTick), this.mc.activeCamera.getYRot(partialTick), this.mc.activeCamera.getXRot(partialTick));
                }
            } else if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && !(this.mc.activeCamera instanceof EntityCameraFirstPerson)) {
                this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, mob);
            } else if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 1 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonRear)) {
                this.mc.activeCamera = new EntityCameraThirdPersonRear(this.mc, mob);
            } else if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 2 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonFront)) {
                this.mc.activeCamera = new EntityCameraThirdPersonFront(this.mc, mob);
            }
        }
    }

    @NotNull
    public Matrix4f orientCamera(@NotNull Matrix4f matrix, float partialTick) {
        Screen screen;
        this.setupCamera(partialTick);
        if (!(this.mc.currentScreen instanceof ScreenPhotoMode) && !((Boolean)GameSettings.LOCK_CAMERA.value).booleanValue()) {
            matrix.rotateX(org.joml.Math.toRadians((float)this.mc.activeCamera.getXRot(partialTick)));
            matrix.rotateY(org.joml.Math.toRadians((float)(this.mc.activeCamera.getYRot(partialTick) + 180.0)));
        }
        if ((screen = this.mc.currentScreen) instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            matrix.rotateX(org.joml.Math.toRadians(screenPhotoMode.getTilt(partialTick)));
            matrix.rotateY(org.joml.Math.toRadians(45.0f + 45.0f * screenPhotoMode.getRotation(partialTick)));
        }
        return matrix;
    }

    @NotNull
    public Matrix4f getProjectionMatrix(@NotNull Matrix4f matrix, float partialTick) {
        matrix.identity();
        this.farPlaneDistance = (Integer)GameSettings.RENDER_DISTANCE.value * 16;
        float fov = this.getFOVModifier(partialTick, true);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        Screen screen = this.mc.currentScreen;
        if (screen instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            double div = Math.pow(2.0, screenPhotoMode.getZoom(partialTick));
            matrix.translate(1.0f, 1.0f, 0.0f);
            matrix.ortho(0.0f, (float)((double)this.mc.gameWindow.getWidthPixels() / div), 0.0f, (float)((double)this.mc.gameWindow.getHeightPixels() / div), this.farPlaneDistance * -2.0f, this.farPlaneDistance * 2.0f);
            matrix.translate(screenPhotoMode.getPanX(partialTick), -screenPhotoMode.getPanY(partialTick), 0.0f);
        } else {
            matrix.identity().perspective(org.joml.Math.toRadians(fov), (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        }
        return matrix;
    }

    @NotNull
    public Matrix4f getViewMatrix(@NotNull Matrix4f matrix, float partialTick) {
        float portalIntensity;
        matrix.identity();
        this.hurtCameraEffect(matrix, partialTick);
        if (((Boolean)GameSettings.VIEW_BOBBING.value).booleanValue() && !(this.mc.currentScreen instanceof ScreenPhotoMode)) {
            this.setupViewBobbing(matrix, partialTick, false);
        }
        float f = portalIntensity = (Boolean)GameSettings.SCREEN_MOTION_EFFECTS.value != false ? MathHelper.lerp(this.mc.thePlayer.prevTimeInPortal, this.mc.thePlayer.timeInPortal, partialTick) : 0.0f;
        if (portalIntensity > 0.0f) {
            float f3 = 5.0f / (portalIntensity * portalIntensity + 5.0f) - portalIntensity * 0.04f;
            f3 *= f3;
            float rotation = org.joml.Math.toRadians(((float)this.tick + partialTick) * 20.0f);
            matrix.rotate(rotation, 0.0f, 0.7071f, 0.7071f);
            matrix.scale(1.0f / f3, 1.0f, 1.0f);
            matrix.rotate(-rotation, 0.0f, 0.7071f, 0.7071f);
        }
        this.orientCamera(matrix, partialTick);
        return matrix;
    }

    private void renderHand(float partialTick) {
        Matrix4f projMat = GLRenderer.projectionM4f();
        projMat.identity();
        this.farPlaneDistance = (Integer)GameSettings.RENDER_DISTANCE.value * 16;
        float fov = this.getFOVModifier(partialTick, false);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        projMat.translate(0.0f, 0.0f, -1.0f);
        projMat.scale(1.0f, 1.0f, 0.1f);
        projMat.perspective(org.joml.Math.toRadians(fov), (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        Matrix4f viewMat = GLRenderer.viewM4f();
        viewMat.identity();
        GLRenderer.modelM4f().identity();
        GLRenderer.pushFrame();
        this.hurtCameraEffect(viewMat, partialTick);
        if (((Boolean)GameSettings.VIEW_BOBBING.value).booleanValue()) {
            this.setupViewBobbing(viewMat, partialTick, true);
        }
        if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && !(this.mc.currentScreen instanceof ScreenPhotoMode) && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).mob.isPlayerSleeping() && GameSettings.IMMERSIVE_MODE.drawHand()) {
            this.lightmapHelper.enableLightmapRendering();
            if (!this.zooming) {
                this.itemRenderer.renderItemInFirstPerson(partialTick);
            }
            this.lightmapHelper.disableLightmapRendering();
        }
        GLRenderer.popFrame();
        Debug.change("post");
        this.mc.renderer.endRenderWorld(partialTick);
        if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).mob.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(partialTick);
            this.hurtCameraEffect(viewMat, partialTick);
        }
        if (((Boolean)GameSettings.VIEW_BOBBING.value).booleanValue()) {
            this.setupViewBobbing(viewMat, partialTick, false);
        }
    }

    private float getZoomedFOV(float currentFov, float partialTick) {
        currentFov *= 0.45f;
        float prevZoomProgress = this.zoomProgress;
        this.zoomProgress -= (float)Mouse.getDWheel() / 4.0f;
        this.zoomProgress = MathHelper.clamp(this.zoomProgress, -7.5f, 7.5f);
        float maxFOV = 160.0f;
        float minFOV = 5.0f;
        float _zoom = prevZoomProgress + (this.zoomProgress - prevZoomProgress) * partialTick;
        if (this.zoomProgress > 0.0f) {
            return currentFov + 2.0f * (160.0f - currentFov) * (this.logisticFunc(_zoom) - 0.5f);
        }
        return 5.0f + 2.0f * (currentFov - 5.0f) * this.logisticFunc(_zoom);
    }

    private float logisticFunc(float val) {
        float L = 1.0f;
        float k = 1.1f;
        float xo = 0.0f;
        return (float)(1.0 / (1.0 + Math.pow(Math.E, -1.1f * (val - 0.0f))));
    }

    public void updateCameraAndRender(float partialTick) {
        this.lightmapHelper.update(partialTick);
        if (this.mc.inGameHasFocus) {
            if (Mouse.isGrabbed()) {
                float sensitivity = ((Float)GameSettings.MOUSE_SENSITIVITY.value).floatValue() * 0.6f + 0.2f;
                sensitivity = sensitivity * sensitivity * sensitivity * 8.0f;
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                float deltaX = (float)this.mc.mouseInput.deltaX * sensitivity;
                float deltaY = (float)this.mc.mouseInput.deltaY * sensitivity;
                int l = 1;
                if (((Boolean)GameSettings.INVERT_MOUSE.value).booleanValue()) {
                    l = -1;
                }
                if (((Boolean)GameSettings.SMOOTH_CAMERA.value).booleanValue()) {
                    deltaX = this.mouseFilterXAxis.getSmoothedDelta(deltaX, 0.05f * sensitivity);
                    deltaY = this.mouseFilterYAxis.getSmoothedDelta(deltaY, 0.05f * sensitivity);
                } else {
                    this.mouseFilterXAxis.reset();
                    this.mouseFilterYAxis.reset();
                }
                this.mc.thePlayer.interpolateTurn(deltaX, deltaY * (float)l);
            }
            if (this.mc.controllerInput != null) {
                double speed = Time.delta * 2000.0 * (double)(((Float)GameSettings.CONTROLLER_SENSITIVITY.value).floatValue() + 0.5f);
                if (this.zooming) {
                    speed *= 0.25;
                }
                double x = (double)this.mc.controllerInput.joyRight.getX() * speed;
                double y = (double)(-this.mc.controllerInput.joyRight.getY()) * speed;
                this.mc.thePlayer.interpolateTurn((float)x, (float)y);
            }
            if (!((Boolean)GameSettings.SHOW_FRAME_TIMES.value).booleanValue()) {
                PlayerInput playerInput = this.mc.thePlayer.input;
                float x = 0.0f;
                float y = 0.0f;
                playerInput.pressedLookUp = GameSettings.KEY_LOOK_UP.isPressed();
                playerInput.pressedLookDown = GameSettings.KEY_LOOK_DOWN.isPressed();
                playerInput.pressedLookLeft = GameSettings.KEY_LOOK_LEFT.isPressed();
                playerInput.pressedLookRight = GameSettings.KEY_LOOK_RIGHT.isPressed();
                if (playerInput.pressedLookUp) {
                    y += 1.0f;
                }
                if (playerInput.pressedLookDown) {
                    y -= 1.0f;
                }
                if (playerInput.pressedLookLeft) {
                    x -= 1.0f;
                }
                if (playerInput.pressedLookRight) {
                    x += 1.0f;
                }
                float sensitivity = (float)(Time.delta * 1000.0 * (double)(((Float)GameSettings.MOUSE_SENSITIVITY.value).floatValue() + 0.5f));
                if (this.mc.thePlayer.isSneaking()) {
                    sensitivity *= 0.5f;
                }
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                this.mc.thePlayer.interpolateTurn(x *= sensitivity, y *= sensitivity);
            }
        }
        if (this.mc.skipRenderWorld) {
            return;
        }
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int mouseX = Mouse.getX() * width / this.mc.resolution.getWidthScreenCoords();
        int mouseY = height - Mouse.getY() * height / this.mc.resolution.getHeightScreenCoords() - 1;
        int c = 200;
        c = (Boolean)GameSettings.ENABLE_VSYNC.value != false ? 999 : (Integer)GameSettings.CUSTOM_FPS_LIMIT.value;
        if (c <= 0) {
            c = 1;
        }
        GL41.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        if (this.mc.currentWorld != null) {
            Debug.change("world");
            if (!((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() && (Integer)GameSettings.CUSTOM_FPS_LIMIT.value == 0) {
                this.renderWorld(partialTick, 0L);
            } else {
                this.renderWorld(partialTick, this.systemTime + 1000000000L / (long)c);
            }
            Debug.change("misc");
            if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() || (Integer)GameSettings.CUSTOM_FPS_LIMIT.value > 0) {
                Debug.change("sleep");
                long timeToSleep = this.systemTime + 1000000000L / (long)c - System.nanoTime();
                long millis = timeToSleep / 1000000L;
                int nanos = (int)(timeToSleep - millis * 1000000L);
                if (millis > 0L && millis < 500L) {
                    try {
                        Thread.sleep(millis, nanos);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
            Debug.change("hud");
            this.mc.hudIngame.renderGameOverlay(partialTick, this.mc.currentScreen != null, mouseX, mouseY);
            Debug.change("misc");
        } else {
            GLRenderer.projectionM4f().identity();
            GLRenderer.viewM4f().identity();
            GLRenderer.modelM4f().identity();
            this.setupScaledResolution();
            if (((Boolean)GameSettings.ENABLE_VSYNC.value).booleanValue() || (Integer)GameSettings.CUSTOM_FPS_LIMIT.value > 0) {
                Debug.change("sleep");
                long l2 = (this.systemTime + 1000000000L / (long)c - System.nanoTime()) / 1000000L;
                if (l2 < 0L) {
                    l2 += 10L;
                }
                if (l2 > 0L && l2 < 500L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
        }
        this.mc.guiToasts.render(partialTick);
        if (this.mc.currentScreen != null) {
            GLRenderer.pushFrame();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.enableState(State.DEPTH_TEST);
            GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
            Debug.change("gui");
            GL41.glClear(256);
            if (this.mc.inputType == InputType.CONTROLLER) {
                mouseX = (int)this.mc.controllerInput.cursorX;
                mouseY = (int)this.mc.controllerInput.cursorY;
            }
            this.mc.currentScreen.setDesiredCursor(CursorShape.ARROW);
            this.mc.currentScreen.render(mouseX, mouseY, partialTick);
            if (this.mc.currentScreen != null) {
                CursorShape newCursor = this.mc.currentScreen.getDesiredCursor();
                if (!((Boolean)GameSettings.DYNAMIC_CURSOR.value).booleanValue()) {
                    newCursor = CursorShape.ARROW;
                }
                if (this.mc.gameWindow.getCursorShape() != newCursor) {
                    this.mc.gameWindow.setCursorShape(newCursor);
                }
            }
            if (this.mc.inputType == InputType.CONTROLLER && this.mc.currentScreen != null) {
                this.mc.currentScreen.drawControllerCursor();
            }
            Debug.change("misc");
            GLRenderer.popFrame();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void renderWorld(float partialTicks, long updateRenderersUntil) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        Debug.push("misc");
        Colorizers.update(false);
        renderGlobal = this.mc.renderGlobal;
        particleEngine = this.mc.particleEngine;
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.enableState(State.DEPTH_TEST);
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.getMouseOver(partialTicks);
        var7_5 = this.mc.activeCamera;
        if (var7_5 instanceof EntityCamera) {
            camera = (EntityCamera)var7_5;
            activeEntity = camera.mob;
            viewEntityX = activeEntity.xo + (activeEntity.x - activeEntity.xo) * (double)partialTicks;
            viewEntityZ = activeEntity.zo + (activeEntity.z - activeEntity.zo) * (double)partialTicks;
            chunkProvider = this.mc.currentWorld.getChunkProvider();
            chunkX = MathHelper.floor_float((int)viewEntityX) >> 4;
            chunkZ = MathHelper.floor_float((int)viewEntityZ) >> 4;
            chunkProvider.setCurrentChunkOver(chunkX, chunkZ);
        }
        this.fogManager.updateFogColor(partialTicks);
        Debug.change("post");
        this.mc.renderer.beginRenderWorld(partialTicks);
        GL41.glClear(16640);
        GLRenderer.enableState(State.CULL_FACE);
        viewEntityX = this.mc.activeCamera;
        if (!(viewEntityX instanceof EntityCamera)) ** GOTO lbl-1000
        entityCamera = (EntityCamera)viewEntityX;
        if (entityCamera.mob.isRemoved()) {
            v0 = 1.0f;
        } else lbl-1000:
        // 2 sources

        {
            v0 = partialTicks;
        }
        pt = v0;
        this.getProjectionMatrix(GLRenderer.projectionM4f(), pt);
        this.getViewMatrix(GLRenderer.viewM4f(), pt);
        CameraFrustum.recalcFrustrum();
        Debug.change("sky");
        if ((Integer)GameSettings.RENDER_DISTANCE.value > 4 && !(this.mc.currentScreen instanceof ScreenModelViewer)) {
            renderGlobal.renderSky(partialTicks);
        }
        Debug.change("misc");
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        this.mc.renderGlobal.cull(this.mc.activeCamera.getFrustum(), partialTicks);
        Debug.change("aurora");
        if (((Boolean)GameSettings.AURORA.value).booleanValue() && ((WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType())).hasAurora()) {
            renderGlobal.renderAurora(this.mc.activeCamera, partialTicks);
        }
        Debug.change("update");
        loops = 1;
        if (GameSettings.KEY_LOAD_CHUNKS_QUICKLY.isPressed()) {
            loops = 40;
        }
        for (i = 0; i < loops; ++i) {
            while (!this.mc.renderGlobal.updateDirtyChunks(this.mc.activeCamera) && updateRenderersUntil != 0L && (timeRemaining = updateRenderersUntil - System.nanoTime()) >= 0L && timeRemaining <= 1000000000L) {
            }
        }
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        TextureRegistry.worldAtlas.bind();
        Debug.change("terrain");
        GLRenderer.pushFrame();
        GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
        GL41.glActiveTexture(33986);
        TextureRegistry.worldAtlas.layerTextureMap.get("emissive").bind();
        GL41.glActiveTexture(33987);
        TextureRegistry.worldAtlas.layerTextureMap.get("maskColor").bind();
        GL41.glActiveTexture(33984);
        Lighting.enableLight();
        GLRenderer.setShader(Shaders.TERRAIN);
        GLRenderer.globalSetUniforms(Shaders.TERRAIN);
        this.lightmapHelper.enableLightmapRendering();
        this.mc.terrainRenderer.renderSolidTerrain(partialTicks);
        GLRenderer.popFrame();
        Debug.change("entities");
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        renderGlobal.renderEntities(this.mc.activeCamera, partialTicks);
        Debug.change("particles");
        GLRenderer.disableState(State.BLEND);
        particleEngine.renderLitParticles(this.mc.activeCamera, partialTicks);
        Lighting.disable();
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        this.mc.renderer.beginRenderParticles(partialTicks);
        particleEngine.renderParticles(this.mc.activeCamera, partialTicks);
        this.mc.renderer.endRenderParticles(partialTicks);
        this.lightmapHelper.disableLightmapRendering();
        Debug.change("outline");
        if (this.mc.objectMouseOver != null) {
            var9_20 = this.mc.objectMouseOver;
            if (var9_20 instanceof HitResult.Tile) {
                hitTile = (HitResult.Tile)var9_20;
                renderGlobal.drawBlockBreaking(this.mc.activeCamera, hitTile, partialTicks);
            }
            renderGlobal.drawSelectionBox(this.mc.activeCamera, this.mc.objectMouseOver, partialTicks);
        }
        Debug.change("debugoverlays");
        if (((Boolean)GameSettings.SHOW_COLLISION_BOXES.value).booleanValue()) {
            renderGlobal.drawDebugEntityOutlines(this.mc.activeCamera, partialTicks);
        }
        if (((Boolean)GameSettings.SHOW_CHUNK_BORDERS.value).booleanValue()) {
            renderGlobal.drawDebugChunkBorders(this.mc.activeCamera, partialTicks);
        }
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        GLRenderer.enableState(State.BLEND);
        GLRenderer.enableState(State.CULL_FACE);
        TextureRegistry.worldAtlas.bind();
        Lighting.enableLight();
        Debug.change("water");
        this.lightmapHelper.enableLightmapRendering();
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.setShader(Shaders.WORLD);
        GLRenderer.globalSetUniforms(Shaders.WORLD);
        this.mc.terrainRenderer.renderTranslucentTerrain(partialTicks);
        GLRenderer.popFrame();
        this.lightmapHelper.disableLightmapRendering();
        Lighting.disable();
        Debug.change("weather");
        GLRenderer.setDepthMask(true);
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.disableState(State.BLEND);
        this.renderPrecipitation(partialTicks);
        if (((Boolean)GameSettings.CLOUDS.value).booleanValue()) {
            Debug.change("clouds");
            GLRenderer.pushFrame();
            fov = this.getFOVModifier(pt, true);
            if (this.zooming) {
                fov = this.getZoomedFOV(fov, pt);
            }
            GLRenderer.projectionM4f().identity().perspective(org.joml.Math.toRadians(fov), (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f * ((Float)GameSettings.CLOUD_RENDER_DISTANCE.value).floatValue());
            this.fogManager.setupFog(-1, this.farPlaneDistance * ((Float)GameSettings.CLOUD_RENDER_DISTANCE.value).floatValue(), partialTicks, GLRenderer.getFogState());
            renderGlobal.renderClouds(partialTicks);
            GLRenderer.popFrame();
        }
        Debug.change("misc");
        this.fogManager.setupFog(1, this.farPlaneDistance, partialTicks, GLRenderer.getFogState());
        var9_21 = this.mc.activeCamera;
        if (!(var9_21 instanceof EntityCamera)) ** GOTO lbl-1000
        camera = (EntityCamera)var9_21;
        if (camera.mob.isRemoved()) {
            v1 = 1.0f;
        } else lbl-1000:
        // 2 sources

        {
            v1 = partialTicks;
        }
        this.renderHand(v1);
        Debug.pop();
        GLRenderer.popFrame();
    }

    private void addRainParticles() {
        IPrecipitation precipitation;
        if (GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.NONE) {
            return;
        }
        @Nullable WorldClient world = this.mc.currentWorld;
        if (world == null) {
            return;
        }
        @Nullable Weather weather = world.getCurrentWeather();
        if (!(weather instanceof IPrecipitation) || !(precipitation = (IPrecipitation)((Object)weather)).spawnRainParticles()) {
            return;
        }
        float rainLevel = world.getWeatherManager().getWeatherIntensity() * world.getWeatherManager().getWeatherPower();
        if (GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.REDUCED) {
            rainLevel /= 2.0f;
        }
        if (rainLevel == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.tick * 312987231L);
        int cameraX = MathHelper.floor(this.mc.activeCamera.getX());
        int cameraY = MathHelper.floor(this.mc.activeCamera.getY());
        int cameraZ = MathHelper.floor(this.mc.activeCamera.getZ());
        int weatherDiameter = 10;
        double rainParticlePositionX = 0.0;
        double rainParticlePositionY = 0.0;
        double rainParticlePositionZ = 0.0;
        int spawnedParticles = 0;
        for (int ii = 0; ii < (int)(100.0f * rainLevel * rainLevel); ++ii) {
            int x = cameraX + this.random.nextInt(10) - this.random.nextInt(10);
            int z = cameraZ + this.random.nextInt(10) - this.random.nextInt(10);
            int heightmapPosition = world.findTopSolidBlock(x, z);
            int blockId = world.getBlockId(x, heightmapPosition - 1, z);
            @NotNull Biome biome = world.getBlockBiome(x, heightmapPosition, z);
            if (biome.blockedWeathers.contains(weather) || heightmapPosition > cameraY + 10 || heightmapPosition < cameraY - 10) continue;
            float blockX = this.random.nextFloat();
            float blockZ = this.random.nextFloat();
            if (blockId == Blocks.AIR.id()) continue;
            if (Blocks.blocksList[blockId].getMaterial() == Materials.LAVA) {
                this.mc.particleEngine.add(new ParticleSmoke(world, (float)x + blockX, (double)((float)heightmapPosition + 0.1f) - Blocks.blocksList[blockId].getBounds().minY(), (float)z + blockZ, 0.0, 0.0, 0.0, 1.0f, 0));
                continue;
            }
            if (this.random.nextInt(++spawnedParticles) == 0) {
                rainParticlePositionX = (float)x + blockX;
                rainParticlePositionY = (double)((float)heightmapPosition + 0.1f) - Blocks.blocksList[blockId].getBounds().minY();
                rainParticlePositionZ = (float)z + blockZ;
            }
            this.mc.particleEngine.add(new ParticleWaterDrop(world, (float)x + blockX, (double)((float)heightmapPosition + 0.1f) - Blocks.blocksList[blockId].getBounds().minY(), (float)z + blockZ));
        }
        if (spawnedParticles > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            float pitch;
            float volume;
            this.rainSoundCounter = 0;
            if (rainParticlePositionY > this.mc.activeCamera.getY() + 1.0 && world.getHeightValue(MathHelper.floor(this.mc.activeCamera.getX()), MathHelper.floor(this.mc.activeCamera.getZ())) > MathHelper.floor(this.mc.activeCamera.getY())) {
                volume = 0.1f;
                pitch = 0.5f;
            } else {
                volume = 0.2f;
                pitch = 1.0f;
            }
            this.mc.currentWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, rainParticlePositionX, rainParticlePositionY, rainParticlePositionZ, "ambient.weather.rain", volume * this.mc.currentWorld.getWeatherManager().getWeatherIntensity() * this.mc.currentWorld.getWeatherManager().getWeatherPower() * 0.5f, pitch);
        }
    }

    protected void renderPrecipitation(float partialTick) {
        @Nullable WorldClient world = this.mc.currentWorld;
        if (world == null) {
            return;
        }
        @Nullable Weather weather = world.getCurrentWeather();
        if (!(weather instanceof IPrecipitation)) {
            return;
        }
        @NotNull IPrecipitation precipitation = (IPrecipitation)((Object)weather);
        int cameraBlockX = MathHelper.floor(this.mc.activeCamera.getX());
        int cameraBlockY = MathHelper.floor(this.mc.activeCamera.getY());
        int cameraBlockZ = MathHelper.floor(this.mc.activeCamera.getZ());
        @NotNull TessellatorShader t = GLRenderer.getTessellator();
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        GLRenderer.setLightmapCoord2i(15, 15);
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        this.mc.textureManager.loadTexture(precipitation.getPrecipitationTexturePath(world.getWeatherManager().getWeatherPower(), world.getWeatherManager().getWeatherIntensity())).bind();
        double lerpedX = this.mc.activeCamera.getX(partialTick);
        double lerpedY = this.mc.activeCamera.getY(partialTick);
        double lerpedZ = this.mc.activeCamera.getZ(partialTick);
        int radius = 10;
        @NotNull TilePos queryPos = new TilePos();
        t.startDrawingQuads();
        for (int x = cameraBlockX - 10; x <= cameraBlockX + 10; ++x) {
            for (int z = cameraBlockZ - 10; z <= cameraBlockZ + 10; ++z) {
                float v;
                float u;
                float vOffset;
                int y1;
                int y0;
                int terrainHeight = Math.max(world.findTopSolidBlock(x, z), 0);
                queryPos.set(x, terrainHeight, z);
                @NotNull Biome biome = world.getBlockBiome(queryPos);
                if (biome.blockedWeathers.contains(weather) || (y0 = Math.max(cameraBlockY - 10, terrainHeight)) == (y1 = Math.max(cameraBlockY + 10, terrainHeight))) continue;
                long seed = (long)(x * x) * 3121L + (long)x * 45238971L + (long)(z * z) * 418711L + (long)z * 13761L;
                this.random.setSeed(seed);
                double relativeX = (double)x + 0.5 - this.mc.activeCamera.getX(partialTick);
                double relativeZ = (double)z + 0.5 - this.mc.activeCamera.getZ(partialTick);
                float distanceSq = MathHelper.sqrt(relativeX * relativeX + relativeZ * relativeZ) / 10.0f;
                float br = this.mc.fullbright ? 1.0f : world.getLightBrightness(queryPos);
                if (precipitation.getPrecipitationType() == IPrecipitation.Type.SNOW_LIKE) {
                    float time = (float)this.tick + partialTick;
                    vOffset = ((float)(this.tick & 0x1FF) + partialTick) / 512.0f;
                    u = this.random.nextFloat() + time * 0.01f * (float)this.random.nextGaussian();
                    v = this.random.nextFloat() + time * (float)this.random.nextGaussian() * 0.001f;
                    t.setColor4f(br, br, br, ((1.0f - distanceSq * distanceSq) * 0.3f + 0.5f) * world.getWeatherManager().getWeatherIntensity() * world.getWeatherManager().getWeatherPower());
                } else if (precipitation.getPrecipitationType() == IPrecipitation.Type.RAIN_LIKE || precipitation.getPrecipitationType() == IPrecipitation.Type.INVERTED_RAIN_LIKE) {
                    float blockPosRainSpeed = 3.0f + this.random.nextFloat();
                    vOffset = ((float)((long)this.tick + seed & 0x1FL) + partialTick) / 32.0f * blockPosRainSpeed;
                    u = 0.0f;
                    v = 0.0f;
                    t.setColor4f(br *= 1.0f, br, br, ((1.0f - distanceSq * distanceSq) * 0.5f + 0.5f) * (world.getWeatherManager().getWeatherIntensity() - 0.1f) * world.getWeatherManager().getWeatherPower());
                    if (precipitation.getPrecipitationType() == IPrecipitation.Type.INVERTED_RAIN_LIKE) {
                        vOffset = -vOffset;
                    }
                } else {
                    throw new IllegalStateException("Illegal weather type!");
                }
                t.setTranslation(-lerpedX, -lerpedY, -lerpedZ);
                t.addVertexWithUV((double)x + 0.0, (double)y0 + 0.0, (double)z + 0.5, 0.0 + (double)u, (double)y0 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 1.0, (double)y0 + 0.0, (double)z + 0.5, 1.0 + (double)u, (double)y0 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 1.0, (double)y1 + 0.0, (double)z + 0.5, 1.0 + (double)u, (double)y1 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 0.0, (double)y1 + 0.0, (double)z + 0.5, 0.0 + (double)u, (double)y1 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 0.5, (double)y0 + 0.0, (double)z + 0.0, 0.0 + (double)u, (double)y0 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 0.5, (double)y0 + 0.0, (double)z + 1.0, 1.0 + (double)u, (double)y0 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 0.5, (double)y1 + 0.0, (double)z + 1.0, 1.0 + (double)u, (double)y1 / 4.0 + (double)vOffset + (double)v);
                t.addVertexWithUV((double)x + 0.5, (double)y1 + 0.0, (double)z + 0.0, 0.0 + (double)u, (double)y1 / 4.0 + (double)vOffset + (double)v);
                t.setTranslation(0.0, 0.0, 0.0);
            }
        }
        t.draw();
        GLRenderer.popFrame();
    }

    public void setupScaledResolution() {
        GL41.glClear(256);
        this.mc.getGuiProjectionMatrix(GLRenderer.projectionM4f());
        this.mc.getGuiViewMatrix(GLRenderer.viewM4f());
    }
}

