/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Global;
import net.minecraft.core.enums.EnumOS;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;

public class OpenGLHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> errors = new HashSet<String>();
    public static int[] versionPairs = new int[]{4, 6, 4, 3, 4, 1};
    public static boolean contextCreated = false;
    public static GLCapabilities capabilities;
    @NotNull
    public static String version;
    @NotNull
    public static String vendor;
    @NotNull
    public static String renderer;
    public static int major;
    public static int minor;
    private static int ATI_STARTING_FREE_AMOUNT;

    public static void testCapabilities(@NotNull GLCapabilities capabilities) {
        contextCreated = true;
        LOGGER.info("");
        LOGGER.info("=== GPU VENDOR INFO ===");
        major = GL41.glGetInteger(33307);
        minor = GL41.glGetInteger(33308);
        LOGGER.info("OpenGL {}.{}", (Object)major, (Object)minor);
        version = Objects.requireNonNullElse(GL41.glGetString(7938), "Query Failure");
        vendor = Objects.requireNonNullElse(GL41.glGetString(7936), "Query Failure");
        renderer = Objects.requireNonNullElse(GL41.glGetString(7937), "Query Failure");
        LOGGER.info(version);
        LOGGER.info(vendor);
        LOGGER.info(renderer);
        LOGGER.info("");
        OpenGLHelper.capabilities = capabilities;
        if (!capabilities.OpenGL41) {
            if (Minecraft.getOs() == EnumOS.macos) {
                LOGGER.warn("BTA Requires OpenGL4.1 but only {} was found! If you're on MacOS this is probably just Apple misreporting the GLVersion number and not actually due to a lack of support.", (Object)version);
            } else {
                LOGGER.error("BTA Requires OpenGL4.1 but only {} was found!", (Object)version);
            }
        }
        if (capabilities.GL_ATI_meminfo) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer intBuff = stack.mallocInt(4);
                GL41.glGetIntegerv(34811, intBuff);
                ATI_STARTING_FREE_AMOUNT = intBuff.get(0);
            }
        }
    }

    public static long totalVRam() {
        if (OpenGLHelper.capabilities.GL_NVX_gpu_memory_info) {
            return GL41.glGetInteger(36935);
        }
        if (OpenGLHelper.capabilities.GL_ATI_meminfo) {
            return ATI_STARTING_FREE_AMOUNT;
        }
        return -1L;
    }

    public static long availableVRam() {
        if (OpenGLHelper.capabilities.GL_NVX_gpu_memory_info) {
            return GL41.glGetInteger(36937);
        }
        if (OpenGLHelper.capabilities.GL_ATI_meminfo) {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer intBuff = stack.mallocInt(4);
                GL41.glGetIntegerv(34811, intBuff);
                long l = intBuff.get(0);
                return l;
            }
        }
        return -1L;
    }

    public static void checkError(String info) {
        int errorCode;
        if (Global.DEBUG_MODE && (errorCode = GL41.glGetError()) != 0) {
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                throw new RuntimeException("OpenGL Error " + error);
            }
            if (!errors.contains(info)) {
                errors.add(info);
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                LOGGER.error("########## GL ERROR ##########");
                LOGGER.error("OpenGL Error {}", (Object)error);
            }
        }
    }

    public static String getErrorDescription(int error) {
        if (error == 1280) {
            return "Invalid Enum";
        }
        if (error == 1281) {
            return "Invalid Value";
        }
        if (error == 1282) {
            return "Invalid Operation";
        }
        if (error == 1286) {
            return "Invalid Framebuffer Operation";
        }
        if (error == 1285) {
            return "Out of Memory";
        }
        if (error == 1284) {
            return "Stack Underflow";
        }
        if (error == 1283) {
            return "Stack Overflow";
        }
        return "Unknown Error";
    }

    static {
        version = "Unknown";
        vendor = "Unknown";
        renderer = "Unknown";
        major = 0;
        minor = 0;
        ATI_STARTING_FREE_AMOUNT = 0;
    }
}

