/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.renderer;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.shader.ShaderGeometry;
import net.minecraft.client.render.shader.ShaderProvider;
import net.minecraft.client.render.shader.ShaderProviderInternal;
import net.minecraft.client.render.uniform.UniformBlock;
import net.minecraft.client.render.uniform.UniformBlockManager;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public final class Shaders {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public static final @NotNull List<@NotNull Shader> ALL_SHADERS = new ArrayList<Shader>();
    @NotNull
    public static final @NotNull Map<@NotNull String, @NotNull Shader> SHADER_MAP = new HashMap<String, Shader>();
    @NotNull
    public static final ShaderProvider PROVIDER_INTERNAL = new ShaderProviderInternal("/shaders/");
    @NotNull
    public static final Shader WORLD = Shaders.register("world", new Shader());
    @NotNull
    public static final Shader AURORA = Shaders.register("aurora", new Shader());
    @NotNull
    public static final Shader ENTITY = Shaders.register("entity", new Shader());
    @NotNull
    public static final Shader TERRAIN = Shaders.register("terrain", new ShaderGeometry());
    @NotNull
    public static final Shader ITEM = Shaders.register("item", new Shader());
    @NotNull
    public static final Shader INTERFACE = Shaders.register("interface", new Shader());
    @NotNull
    public static final Shader COLOR = Shaders.register("color", new Shader());
    @NotNull
    public static final Shader COLOR_WORLD = Shaders.register("color_world", new Shader());
    @NotNull
    public static final Shader CLOUDS = Shaders.register("clouds", new Shader());
    @NotNull
    public static final ShaderGeometry PARTICLE = Shaders.register("particle", new ShaderGeometry());
    @NotNull
    public static final ShaderGeometry FONT = Shaders.register("font", new ShaderGeometry());
    @NotNull
    public static final ShaderGeometry LINES = Shaders.register("lines", new ShaderGeometry());
    @NotNull
    public static final ShaderGeometry LOD = Shaders.register("lod", new ShaderGeometry());

    @NotNull
    public static <T extends Shader> T register(@NotNull String id, @NotNull T shader) {
        if (!ALL_SHADERS.contains(shader)) {
            ALL_SHADERS.add(shader);
        }
        SHADER_MAP.put(id, shader);
        return shader;
    }

    public static void init() {
        for (Map.Entry<String, Shader> entry : SHADER_MAP.entrySet()) {
            try {
                entry.getValue().compile(PROVIDER_INTERNAL, entry.getKey());
                for (UniformBlock<?> block : UniformBlockManager.nameToBlockMap.values()) {
                    entry.getValue().uniformBlockBinding(block.name, block.index);
                }
                entry.getValue().bind();
                entry.getValue().uniformInt("colortex", 0);
                entry.getValue().uniformInt("lighttex", 1);
                entry.getValue().uniformInt("emissivetex", 2);
                entry.getValue().uniformInt("colormasktex", 3);
                GL41.glUseProgram(0);
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        }
    }

    public static void reload() {
        for (Map.Entry<String, Shader> entry : SHADER_MAP.entrySet()) {
            try {
                entry.getValue().delete();
                entry.getValue().compile(PROVIDER_INTERNAL, entry.getKey());
                for (UniformBlock<?> block : UniformBlockManager.nameToBlockMap.values()) {
                    entry.getValue().uniformBlockBinding(block.name, block.index);
                }
                entry.getValue().bind();
                GL41.glUniform1i(entry.getValue().getUniform("colortex"), 0);
                GL41.glUniform1i(entry.getValue().getUniform("lighttex"), 1);
                entry.getValue().uniformInt("colortex", 0);
                entry.getValue().uniformInt("lighttex", 1);
                entry.getValue().uniformInt("emissivetex", 2);
                entry.getValue().uniformInt("colormasktex", 3);
                GL41.glUseProgram(0);
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        }
    }
}

