/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMud
extends BlockLogic {
    private final boolean isHardened;

    public BlockLogicMud(@NotNull Block<?> block, @NotNull Material material, boolean isHardened) {
        super(block, material);
        this.isHardened = isHardened;
    }

    @Override
    public int tickDelay() {
        return 5;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
    }

    private boolean isWaterNearby(@NotNull World world, @NotNull TilePosc tilePos, int range) {
        TilePos queryPos = new TilePos(tilePos);
        queryPos.x = tilePos.x() - range;
        while (queryPos.x <= tilePos.x() + range) {
            queryPos.y = tilePos.y() - range;
            while (queryPos.y <= tilePos.y() + range) {
                queryPos.z = tilePos.z() - range;
                while (queryPos.z <= tilePos.z() + range) {
                    if (world.getBlockType(queryPos).hasTag(BlockTags.IS_WATER)) {
                        return true;
                    }
                    ++queryPos.z;
                }
                ++queryPos.y;
            }
            ++queryPos.x;
        }
        return false;
    }

    private boolean isLavaNearby(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos(tilePos);
        queryPos.x = tilePos.x() - 1;
        while (queryPos.x <= tilePos.x() + 1) {
            queryPos.y = tilePos.y() - 1;
            while (queryPos.y <= tilePos.y() + 1) {
                queryPos.z = tilePos.z() - 1;
                while (queryPos.z <= tilePos.z() + 1) {
                    if (world.getBlockType(queryPos).hasTag(BlockTags.IS_LAVA)) {
                        return true;
                    }
                    ++queryPos.z;
                }
                ++queryPos.y;
            }
            ++queryPos.x;
        }
        return false;
    }

    private boolean canBecomeWet(@NotNull World world, @NotNull TilePosc tilePos) {
        if (this.isWaterNearby(world, tilePos, 1)) {
            return true;
        }
        if (this.isWaterNearby(world, tilePos, 3)) {
            TilePos queryPos = new TilePos(tilePos);
            queryPos.x = tilePos.x() - 1;
            while (queryPos.x <= tilePos.x() + 1) {
                queryPos.y = tilePos.y() - 1;
                while (queryPos.y <= tilePos.y() + 1) {
                    queryPos.z = tilePos.z() - 1;
                    while (queryPos.z <= tilePos.z() + 1) {
                        @NotNull Block<?> block = world.getBlockType(queryPos);
                        if (block == Blocks.MUD || block == Blocks.FARMLAND_DIRT && BlockLogicFarmland.isWet(world.getBlockData(queryPos))) {
                            return true;
                        }
                        ++queryPos.z;
                    }
                    ++queryPos.y;
                }
                ++queryPos.x;
            }
        }
        return false;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this, 1, data)};
    }

    private void tryToFall(@NotNull World world, @NotNull TilePosc tilePos) {
        if (world.getBlockType(tilePos) == Blocks.MUD_BAKED) {
            return;
        }
        TilePos queryPos = new TilePos();
        if (BlockLogicMud.canFallBelow(world, tilePos.down(queryPos)) && tilePos.y() >= 0) {
            int radius = 32;
            if (!world.areBlocksLoaded((TilePosc)tilePos.add(-radius, -radius, -radius, new TilePos()), tilePos.add(radius, radius, radius, new TilePos()))) {
                int checkY;
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
                int checkX = tilePos.x();
                int checkZ = tilePos.z();
                for (checkY = tilePos.y() - 1; BlockLogicMud.canFallBelow(world, queryPos.set(checkX, checkY, checkZ)) && checkY >= 0; --checkY) {
                }
                if (checkY > 0) {
                    world.setBlockTypeNotify(queryPos.set(checkX, checkY, checkZ), this.block);
                }
            } else {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, this.block.id(), 0, null);
                world.entityJoinedWorld(entityFallingBlock);
            }
        }
    }

    public static boolean canFallBelow(@NotNull World world, @NotNull TilePos tilePos) {
        @NotNull Block<?> block = world.getBlockType(tilePos);
        return block == Blocks.AIR || block == Blocks.FIRE || block.hasTag(BlockTags.IS_WATER) || block.hasTag(BlockTags.IS_LAVA);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (this.isHardened && !world.getWorldType().hasTag(WorldTypeTags.HOT) && !this.isLavaNearby(world, tilePos) && this.canBecomeWet(world, tilePos)) {
            world.setBlockType(tilePos, Blocks.MUD);
            world.notifyBlockChange(tilePos, Blocks.MUD);
            return;
        }
        if (!this.isHardened && (this.isLavaNearby(world, tilePos) || world.getWorldType().hasTag(WorldTypeTags.HOT))) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)tilePos.x() + Math.random(), (double)tilePos.y() + Math.random(), (double)tilePos.z() + Math.random(), 0.0, 0.0, 0.0, 0);
            }
            world.setBlockType(tilePos, Blocks.MUD_BAKED);
            world.notifyBlockChange(tilePos, Blocks.MUD_BAKED);
            return;
        }
        this.tryToFall(world, tilePos);
    }
}

