/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypeDebug;
import net.minecraft.core.world.type.WorldTypeEmpty;
import net.minecraft.core.world.type.drift.WorldTypeDrift;
import net.minecraft.core.world.type.nether.WorldTypeNether;
import net.minecraft.core.world.type.nether.WorldTypeNetherSkyblock;
import net.minecraft.core.world.type.overworld.WorldTypeFlat;
import net.minecraft.core.world.type.overworld.WorldTypeOverworld;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldB173;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldClassic;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldFloating;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldHell;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldIndev;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldInland;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldParadise;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldRetro;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldSkyblock;
import net.minecraft.core.world.type.overworld.WorldTypeOverworldWoods;
import net.minecraft.core.world.type.tag.WorldTypeTags;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;

public abstract class WorldTypes {
    @NotNull
    public static final WorldType OVERWORLD_EXTENDED = WorldTypes.register("minecraft:overworld.extended", new WorldTypeOverworld(WorldTypeOverworld.defaultProperties("worldType.overworld.extended").withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_DEFAULT = WorldTypes.register("minecraft:overworld.default", new WorldTypeOverworld(WorldTypeOverworld.defaultProperties("worldType.overworld.default").bounds(0, 127, 64).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType NETHER_DEFAULT = WorldTypes.register("minecraft:nether.default", new WorldTypeNether(WorldTypeNether.defaultProperties("worldType.nether.default").portalBounds(63, 255).withTags(WorldTypeTags.NETHER, WorldTypeTags.HOT, WorldTypeTags.BREAKS_COMPASS, WorldTypeTags.BREAKS_TIMEPIECES)));
    @NotNull
    public static final WorldType NETHER_SKYBLOCK = WorldTypes.register("minecraft:nether.skyblock", new WorldTypeNetherSkyblock(WorldTypeNether.defaultProperties("worldType.nether.skyblock").bounds(0, 127, 0).withTags(WorldTypeTags.NETHER, WorldTypeTags.HOT, WorldTypeTags.BREAKS_COMPASS, WorldTypeTags.BREAKS_TIMEPIECES)));
    @NotNull
    public static final WorldType DRIFT_DEFAULT = WorldTypes.register("minecraft:drift.default", new WorldTypeDrift(WorldTypeDrift.defaultProperties("worldType.drift.default").withTags(WorldTypeTags.DRIFT, WorldTypeTags.COLD, WorldTypeTags.BREAKS_COMPASS, WorldTypeTags.BREAKS_TIMEPIECES)));
    @NotNull
    public static final WorldType FLAT = WorldTypes.register("minecraft:flat", new WorldTypeFlat(WorldType.Properties.of("worldType.flat").brightnessRamp(WorldTypeOverworld.createLightRamp()).fillerBlock(Blocks.STONE).allowRespawn().bounds(0, 31, 0).portalBounds(0, 255).seasonConfig(SeasonConfig.builder().withSingleSeason(Seasons.OVERWORLD_SUMMER).build()).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_FLOATING = WorldTypes.register("minecraft:overworld.floating", new WorldTypeOverworldFloating(WorldTypeOverworld.defaultProperties("worldType.overworld.floating").bounds(0, 255, 0).oceanBlock(null).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_AMPLIFIED = WorldTypes.register("minecraft:overworld.amplified", new WorldTypeOverworld(WorldTypeOverworld.defaultProperties("worldType.overworld.amplified").bounds(0, 255, 64).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_RETRO = WorldTypes.register("minecraft:overworld.retro", new WorldTypeOverworldRetro(WorldTypeOverworld.defaultProperties("worldType.overworld.retro").seasonConfig(null).bounds(0, 127, 64).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD, WorldTypeTags.RETRO)));
    @NotNull
    public static final WorldType OVERWORLD_ISLANDS = WorldTypes.register("minecraft:overworld.islands", new WorldTypeOverworld(WorldTypeOverworld.defaultProperties("worldType.overworld.islands").bounds(0, 255, 160).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_WINTER = WorldTypes.register("minecraft:overworld.winter", new WorldTypeOverworld(WorldTypeOverworld.defaultProperties("worldType.overworld.winter").seasonConfig(SeasonConfig.builder().withSingleSeason(Seasons.OVERWORLD_WINTER_ENDLESS).build()).bounds(0, 127, 64).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD, WorldTypeTags.ENDLESS_SNOW, WorldTypeTags.COLD)));
    @NotNull
    public static final WorldType OVERWORLD_HELL = WorldTypes.register("minecraft:overworld.hell", new WorldTypeOverworldHell(WorldType.Properties.of("worldType.overworld.hell").brightnessRamp(WorldTypeOverworld.createLightRamp()).seasonConfig(SeasonConfig.builder().withSingleSeason(Seasons.OVERWORLD_HELL).build()).oceanBlock(Blocks.FLUID_LAVA_STILL).fillerBlock(Blocks.STONE).allowRespawn().bounds(0, 127, 64).portalBounds(0, 255).defaultWeather(Weathers.OVERWORLD_HELL_CLEAR).withTags(WorldTypeTags.OVERWORLD, WorldTypeTags.HOT)));
    @NotNull
    public static final WorldType OVERWORLD_WOODS = WorldTypes.register("minecraft:overworld.woods", new WorldTypeOverworldWoods(WorldTypeOverworld.defaultProperties("worldType.overworld.woods").defaultWeather(Weathers.OVERWORLD_WOODS_CLEAR).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_PARADISE = WorldTypes.register("minecraft:overworld.paradise", new WorldTypeOverworldParadise(WorldTypeOverworld.defaultProperties("worldType.overworld.paradise").seasonConfig(SeasonConfig.builder().withSingleSeason(Seasons.OVERWORLD_SPRING).build()).bounds(0, 127, 64).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_INLAND = WorldTypes.register("minecraft:overworld.inland", new WorldTypeOverworldInland(WorldTypeOverworld.defaultProperties("worldType.overworld.inland").bounds(0, 255, 0).oceanBlock(null).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_CLASSIC = WorldTypes.register("minecraft:overworld.classic", new WorldTypeOverworldClassic(WorldTypeOverworld.defaultProperties("worldType.overworld.classic").seasonConfig(null).bounds(0, 127, 64).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD, WorldTypeTags.RETRO)));
    @NotNull
    public static final WorldType OVERWORLD_INDEV = WorldTypes.register("minecraft:overworld.indev", new WorldTypeOverworldIndev(WorldTypeOverworld.defaultProperties("worldType.overworld.indev").seasonConfig(null).bounds(0, 127, 64).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD, WorldTypeTags.RETRO)));
    @NotNull
    public static final WorldType OVERWORLD_SKYBLOCK = WorldTypes.register("minecraft:overworld.skyblock", new WorldTypeOverworldSkyblock(WorldTypeOverworld.defaultProperties("worldType.overworld.skyblock").bounds(0, 127, 0).portalBounds(0, 255).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType OVERWORLD_BETA_173 = WorldTypes.register("minecraft:overworld.beta_173", new WorldTypeOverworldB173(WorldTypeOverworld.defaultProperties("worldType.overworld.beta_173").bounds(0, 127, 64).withTags(WorldTypeTags.OVERWORLD)));
    @NotNull
    public static final WorldType EMPTY = WorldTypes.register("minecraft:empty", new WorldTypeEmpty(WorldType.Properties.of("worldType.empty").brightnessRamp(WorldTypeEmpty.createLightRamp()).bounds(0, 255, 0).allowRespawn()));
    @NotNull
    public static final WorldType DEBUG = WorldTypes.register("minecraft:debug", new WorldTypeDebug(WorldType.Properties.of("worldType.debug").brightnessRamp(WorldTypeDebug.createLightRamp()).bounds(0, 255, 0).allowRespawn()));

    @NotNull
    public static WorldType register(@NotNull String key, @NotNull WorldType worldType) {
        Registries.WORLD_TYPES.register(key, worldType);
        return worldType;
    }

    public static void init() {
    }
}

