/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ByteTag
extends Tag<Byte> {
    public ByteTag() {
        this(0);
    }

    public ByteTag(byte value) {
        super(value);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeByte(((Byte)this.getValue()).byteValue());
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        this.setValue(dis.readByte());
    }

    @Override
    public byte getId() {
        return Tag.TagID.TAG_BYTE.getId();
    }

    public String toString() {
        return "\"" + this.getTagName() + "\": " + String.valueOf(this.getValue());
    }

    @Override
    public void fromJson(@NotNull JsonElement json) throws JsonParseException {
        if (!json.isJsonPrimitive()) {
            throw new JsonParseException("Json element '" + String.valueOf(json) + "' is not a valid byteTag!");
        }
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (!primitive.isNumber()) {
            throw new JsonParseException("Json element '" + String.valueOf(json) + "' is not a number!");
        }
        this.setValue(primitive.getAsByte());
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        return new JsonPrimitive((Number)this.getValue());
    }
}

