/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console;

import com.mojang.logging.LogQueues;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.console.LogMessage;
import org.jetbrains.annotations.NotNull;

public abstract class LogMessageReceiver {
    private static final int MESSAGE_CACHE_SIZE = 1000;
    @NotNull
    private static final @NotNull List<@NotNull LogMessage> MESSAGE_QUEUE = new ArrayList<LogMessage>(1000);
    @NotNull
    private static final @NotNull List<@NotNull Consumer<@NotNull LogMessage>> CALLBACKS = new ArrayList<Consumer<LogMessage>>();

    public static void init() {
        @NotNull Thread logAppenderThread = new Thread(() -> {
            String logEvent;
            while ((logEvent = LogQueues.getNextLogEvent("IngameConsole")) != null) {
                LogMessageReceiver.append(logEvent);
            }
        });
        logAppenderThread.setDaemon(true);
        logAppenderThread.start();
    }

    public static void append(@NotNull String message) {
        @NotNull LogMessage logMessage = new LogMessage(message);
        MESSAGE_QUEUE.add(logMessage);
        if (MESSAGE_QUEUE.size() > 1000) {
            MESSAGE_QUEUE.remove(0);
        }
        for (Consumer<LogMessage> consumer : CALLBACKS) {
            consumer.accept(logMessage);
        }
    }

    public static void addCallback(@NotNull @NotNull Consumer<@NotNull LogMessage> callback) {
        CALLBACKS.add(callback);
    }

    @NotNull
    public static @NotNull List<@NotNull LogMessage> getQueue() {
        return MESSAGE_QUEUE;
    }
}

